/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.registry;

import electric.glue.IGLUELoggingConstants;
import electric.proxy.IReference;
import electric.registry.IRegistry;
import electric.registry.RegistryException;
import electric.soap.java.reference.JavaToSOAP;
import electric.soap.references.ISOAPReference;
import electric.soap.references.SOAPReferenceFactories;
import electric.util.Context;
import electric.util.XURL;
import electric.util.array.ArrayUtil;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.wsdl.IWSDLConstants;
import electric.wsdl.Port;
import electric.wsdl.WSDL;
import electric.wsdl.loader.WSDLLoader;
import java.net.MalformedURLException;

public final class SOAPRegistry
implements IRegistry,
IWSDLConstants,
IGLUELoggingConstants {
    private static final String[] protocols = new String[]{"http", "https", "jms", "file", "soaplocal"};
    static /* synthetic */ Class class$electric$soap$wsdl$SOAPPort;

    public IReference bind(String path, Class[] interfaces, Context proxyContext) throws RegistryException {
        if (path == null) {
            return null;
        }
        String protocol = XURL.getProtocol(path);
        if (protocol == null || !this.isSupportedProtocol(protocol)) {
            return null;
        }
        try {
            WSDL wsdl = WSDLLoader.getWSDL(path, proxyContext);
            XURL endpoint = this.getEndpoint(path, protocol, wsdl, proxyContext);
            ISOAPReference soapReference = SOAPReferenceFactories.newSOAPReference(endpoint, wsdl, proxyContext);
            if (soapReference == null) {
                throw new RegistryException("could not create soap reference chain");
            }
            return new JavaToSOAP(endpoint, soapReference, proxyContext);
        }
        catch (RegistryException exception) {
            throw exception;
        }
        catch (Exception exception) {
            String error = "could not bind to path: " + path;
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, error, exception);
            }
            throw new RegistryException(error, exception);
        }
    }

    private boolean isSupportedProtocol(String protocol) {
        return ArrayUtil.indexOf(protocol, protocols) != -1;
    }

    private XURL getEndpoint(String path, String protocol, WSDL wsdl, Context context) throws RegistryException, MalformedURLException {
        String endpointProperty = context.getStringProperty("endpoint");
        if (endpointProperty != null) {
            return new XURL(endpointProperty);
        }
        Port[] ports = wsdl.getPorts(class$electric$soap$wsdl$SOAPPort == null ? (class$electric$soap$wsdl$SOAPPort = SOAPRegistry.class$("electric.soap.wsdl.SOAPPort")) : class$electric$soap$wsdl$SOAPPort);
        if (ports.length == 0) {
            throw new RegistryException("no soap port found for " + path);
        }
        int index = -1;
        int i = 0;
        while (i < ports.length) {
            Port port = ports[i];
            String portProtocol = port.getEndpoint().getProtocol();
            if (protocol.equalsIgnoreCase(portProtocol)) {
                return port.getEndpoint();
            }
            if (this.closeMatch(protocol, portProtocol)) {
                index = i;
            }
            ++i;
        }
        return index != -1 ? ports[index].getEndpoint() : ports[0].getEndpoint();
    }

    private boolean closeMatch(String protocol1, String protocol2) {
        if ("http".equalsIgnoreCase(protocol1)) {
            return "https".equalsIgnoreCase(protocol2);
        }
        if ("https".equalsIgnoreCase(protocol1)) {
            return "http".equalsIgnoreCase(protocol2);
        }
        return false;
    }

    public boolean publish(String path, Object object, Context context) {
        return false;
    }

    public boolean unpublish(String path) {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

