/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.references;

import electric.soap.references.Entry;
import electric.soap.references.ISOAPReference;
import electric.soap.references.ISOAPReferenceFactory;
import electric.soap.references.chain.IChainedSOAPReference;
import electric.util.Context;
import electric.util.XURL;
import electric.util.array.ArrayUtil;
import electric.wsdl.WSDL;
import java.util.Vector;

public class SOAPReferenceFactories {
    private static final int DEFAULT_PRIORITY = 5;
    private static Entry[] entries = new Entry[0];

    public static void addFactory(String name, ISOAPReferenceFactory factory) {
        SOAPReferenceFactories.addFactory(name, factory, 5.0f);
    }

    public static void addFactory(String name, ISOAPReferenceFactory factory, float priority) {
        Entry entry = new Entry(name, priority, factory);
        int i = 0;
        while (i < entries.length) {
            if (priority < SOAPReferenceFactories.entries[i].priority) {
                entries = (Entry[])ArrayUtil.insertElementAt(entries, entry, i);
                return;
            }
            ++i;
        }
        entries = (Entry[])ArrayUtil.addElement(entries, entry);
    }

    public static void removeFactory(String name) {
        int i = 0;
        while (i < entries.length) {
            if (SOAPReferenceFactories.entries[i].name.equals(name)) {
                entries = (Entry[])ArrayUtil.removeElement(entries, entries[i]);
            }
            ++i;
        }
    }

    public static ISOAPReferenceFactory getFactory(String name) {
        int i = 0;
        while (i < entries.length) {
            if (SOAPReferenceFactories.entries[i].name.equals(name)) {
                return SOAPReferenceFactories.entries[i].factory;
            }
            ++i;
        }
        return null;
    }

    public static int getIndex(ISOAPReferenceFactory factory) {
        int i = 0;
        while (i < entries.length) {
            if (SOAPReferenceFactories.entries[i].factory == factory) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static ISOAPReference newSOAPReference(XURL endpoint, WSDL wsdl, Context proxyContext) {
        return SOAPReferenceFactories.newSOAPReference(endpoint, wsdl, proxyContext, 0);
    }

    public static ISOAPReference newSOAPReference(XURL endpoint, WSDL wsdl, Context proxyContext, int index) {
        Vector referenceChain = new Vector();
        boolean stop = false;
        int i = index;
        while (i < entries.length) {
            stop = SOAPReferenceFactories.entries[i].factory.newSOAPReference(referenceChain, endpoint, wsdl, proxyContext);
            if (stop) break;
            ++i;
        }
        if (!stop) {
            return null;
        }
        int i2 = 0;
        while (i2 < referenceChain.size() - 1) {
            IChainedSOAPReference reference = (IChainedSOAPReference)referenceChain.elementAt(i2);
            ISOAPReference nextReference = (ISOAPReference)referenceChain.elementAt(i2 + 1);
            reference.setNextReference(nextReference);
            ++i2;
        }
        return (ISOAPReference)referenceChain.elementAt(0);
    }
}

