/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.local.reference;

import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.server.Servers;
import electric.service.IService;
import electric.soap.local.reference.SOAPLocalTransport;
import electric.soap.references.ISOAPReferenceFactory;
import electric.util.Context;
import electric.util.XURL;
import electric.wsdl.WSDL;
import java.net.MalformedURLException;
import java.util.Vector;

public class SOAPLocalTransportFactory
implements ISOAPReferenceFactory {
    public boolean newSOAPReference(Vector referenceChain, XURL endpoint, WSDL wsdl, Context proxyContext) {
        String file = endpoint.getFile();
        if (file == null || file.startsWith("?")) {
            return false;
        }
        try {
            String localPath = null;
            localPath = endpoint.getProtocol() != null ? (endpoint.getProtocol().equals("soaplocal") ? file : Servers.getLocalPath(endpoint)) : file;
            if (localPath == null) {
                return false;
            }
            Object registryObject = Registry.get(localPath);
            if (registryObject == null || !(registryObject instanceof IService)) {
                return false;
            }
            SOAPLocalTransport reference = new SOAPLocalTransport(new XURL(localPath), (IService)registryObject);
            referenceChain.addElement(reference);
            return true;
        }
        catch (MalformedURLException exception) {
            return false;
        }
        catch (RegistryException exception) {
            return false;
        }
    }
}

