/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.http.reference;

import electric.glue.IGLUELoggingConstants;
import electric.http.InboundHTTPResponse;
import electric.http.OutboundHTTPRequest;
import electric.soap.ISOAPConstants;
import electric.soap.SOAPMessage;
import electric.soap.SOAPOptimizations;
import electric.util.Context;
import electric.util.array.ByteArray;
import electric.util.http.IHTTPConstants;
import electric.util.io.StreamSource;
import electric.util.io.Streams;
import electric.util.mime.MIMEBuilder;
import electric.util.mime.MIMEData;
import electric.util.mime.MIMEHeaders;
import electric.util.mime.MIMEReader;
import electric.util.mime.MemoryDataHandler;
import electric.wsdl.WSDL;
import electric.xml.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;

public class ClientMIME
implements ISOAPConstants,
IHTTPConstants,
IGLUELoggingConstants {
    public static void populateRequest(SOAPMessage soapRequest, OutboundHTTPRequest httpRequest, WSDL wsdl, Enumeration unreferencedAttachments) throws IOException {
        MIMEHeaders headers = new MIMEHeaders();
        headers.setHeader("Content-Type", "text/xml; charset=UTF-8");
        MIMEData[] attachments = soapRequest.getAttachments();
        ByteArray byteArray = soapRequest.getByteArray(wsdl);
        MIMEBuilder builder = new MIMEBuilder(attachments, byteArray, headers);
        httpRequest.setContentType(builder.getContentType());
        InputStream inputStream = builder.getInputStream();
        int contentLength = builder.getContentLength();
        StreamSource source = new StreamSource(inputStream, contentLength, IGLUELoggingConstants.HTTP_EVENT);
        httpRequest.setSource(source);
    }

    public static SOAPMessage readResponse(InboundHTTPResponse httpResponse, SOAPOptimizations optimizations, Context proxyContext, WSDL wsdl) throws IOException, ParseException {
        String contentType = httpResponse.getContentType();
        String location = httpResponse.getHeader("Content-Location");
        InputStream httpInput = httpResponse.getInputStream();
        MIMEReader mimeReader = new MIMEReader(httpInput, contentType, location, proxyContext, new MemoryDataHandler());
        MIMEData startPart = mimeReader.getStartPart();
        byte[] bytes = Streams.readFully(startPart.getInputStream(), startPart.getContentLength());
        SOAPMessage soapMessage = new SOAPMessage();
        soapMessage.setBytes(bytes, optimizations, wsdl);
        soapMessage.setAttachments(mimeReader.getOtherParts());
        return soapMessage;
    }
}

