/*
 * Decompiled with CFR 0.152.
 */
package electric.servlet.webinf;

import electric.glue.IGLUELoggingConstants;
import electric.security.IRealm;
import electric.security.Realms;
import electric.security.guards.Role;
import electric.servlet.Config;
import electric.servlet.HTTPContext;
import electric.servlet.filters.ServletFilterConfig;
import electric.servlet.webinf.IWebInfConstants;
import electric.util.array.ArrayUtil;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.xml.Element;
import electric.xml.Elements;

public final class WebInf
implements IWebInfConstants,
IGLUELoggingConstants {
    private Element root;

    public WebInf(Element root) {
        this.root = root;
    }

    public HTTPContext getHTTPContext(String docBase) throws Exception {
        HTTPContext context = new HTTPContext(docBase);
        this.setMimeMappings(context);
        this.setWelcomeFileList(context);
        this.setErrorPages(context);
        this.setContextParameters(context);
        this.setFilters(context);
        this.setFilterMappings(context);
        this.setServlets(context);
        this.setServletMappings(context);
        this.setSecurityConstraints(context);
        this.setLoginConfig(context);
        this.setDisplayName(context);
        this.setListeners(context);
        return context;
    }

    private void setMimeMappings(HTTPContext context) {
        Elements elements = this.root.getElements("mime-mapping");
        while (elements.hasMoreElements()) {
            Element mimeMapping = elements.next();
            String extension = mimeMapping.getString("extension");
            String mimeType = mimeMapping.getString("mime-type");
            context.addMimeType(extension, mimeType);
        }
    }

    private void setWelcomeFileList(HTTPContext context) {
        Elements elements = this.root.getElements("welcome-file-list");
        while (elements.hasMoreElements()) {
            Element welcomeFile = elements.next();
            String fileName = welcomeFile.getString("welcome-file");
            context.addWelcomeFile(fileName);
        }
    }

    private void setErrorPages(HTTPContext context) {
        Elements elements = this.root.getElements("error-page");
        while (elements.hasMoreElements()) {
            String errorCode;
            Element errorPage = elements.next();
            String location = errorPage.getString("location");
            String exceptionType = errorPage.getString("exception-type");
            if (exceptionType != null) {
                context.addErrorPage(exceptionType, location);
            }
            if ((errorCode = errorPage.getString("error-code")) == null) continue;
            context.addErrorPage(Integer.parseInt(errorCode), location);
        }
    }

    private void setContextParameters(HTTPContext context) {
        Elements elements = this.root.getElements("context-param");
        while (elements.hasMoreElements()) {
            Element contextParam = elements.next();
            String name = contextParam.getString("param-name");
            String value = contextParam.getString("param-value");
            context.addInitParameter(name, value);
        }
    }

    private void setDisplayName(HTTPContext context) {
        Element displayNameElement = this.root.getElement("display-name");
        if (displayNameElement == null) {
            return;
        }
        String displayName = displayNameElement.getTrimTextString();
        context.setServletContextName(displayName);
    }

    private void setFilters(HTTPContext context) {
        Elements elements = this.root.getElements("filter");
        while (elements.hasMoreElements()) {
            Element filter = elements.next();
            String filterName = filter.getTextString("filter-name").trim();
            String filterClassName = filter.getTextString("filter-class").trim();
            ServletFilterConfig config = new ServletFilterConfig(context, filterName, filterClassName);
            Elements inits = filter.getElements("init-param");
            while (inits.hasMoreElements()) {
                Element initParam = inits.next();
                String name = initParam.getTextString("param-name").trim();
                String value = initParam.getTextString("param-value").trim();
                config.addInitParameter(name, value);
            }
            context.addFilterConfig(config);
        }
    }

    private void setFilterMappings(HTTPContext context) {
        Elements elements = this.root.getElements("filter-mapping");
        while (elements.hasMoreElements()) {
            String urlPattern;
            Element filter = elements.next();
            String filterName = filter.getTextString("filter-name").trim();
            String servletName = filter.getTextString("servlet-name");
            if (servletName != null) {
                servletName = servletName.trim();
            }
            if ((urlPattern = filter.getTextString("url-pattern")) != null) {
                urlPattern = urlPattern.trim();
            }
            context.addFilterMapping(filterName, servletName, urlPattern);
        }
    }

    private void setServlets(HTTPContext context) {
        Elements elements = this.root.getElements("servlet");
        while (elements.hasMoreElements()) {
            Element servlet = elements.next();
            String servletName = servlet.getString("servlet-name");
            String className = servlet.getString("servlet-class");
            if (className == null) {
                Log.log(ILoggingConstants.WARNING_EVENT, (Object)("servlet-name " + servletName + " does not have a " + "servlet-class"));
                Log.log(ILoggingConstants.WARNING_EVENT, (Object)"skipping...");
                continue;
            }
            Config config = new Config(servletName, className);
            String loadOnStartup = servlet.getString("load-on-startup");
            if (loadOnStartup != null) {
                config.setLoadOnStartup(Integer.parseInt(loadOnStartup));
            }
            Elements inits = servlet.getElements("init-param");
            while (inits.hasMoreElements()) {
                Element initParam = inits.next();
                String name = initParam.getString("param-name");
                String value = initParam.getString("param-value");
                config.addInitParameter(name, value);
            }
            context.addConfig(config);
        }
    }

    private void setServletMappings(HTTPContext context) {
        Elements elements = this.root.getElements("servlet-mapping");
        while (elements.hasMoreElements()) {
            Element mapping = elements.next();
            String urlPattern = mapping.getTextString("url-pattern");
            String servletName = mapping.getTextString("servlet-name");
            if (urlPattern == null || urlPattern.length() == 0) continue;
            urlPattern = urlPattern.trim();
            if (servletName == null || servletName.length() == 0) continue;
            servletName = servletName.trim();
            context.addServletMapping(servletName, urlPattern);
        }
    }

    private void setSecurityConstraints(HTTPContext context) {
        Elements elements = this.root.getElements("security-constraint");
        while (elements.hasMoreElements()) {
            Elements enum2;
            Element securityConstraint = elements.next();
            String[] roles = new String[]{};
            Element authConstraint = securityConstraint.getElement("auth-constraint");
            if (authConstraint != null) {
                enum2 = authConstraint.getElements("role-name");
                while (enum2.hasMoreElements()) {
                    String role = enum2.next().getString();
                    roles = (String[])ArrayUtil.addElement(roles, role);
                }
            }
            enum2 = securityConstraint.getElements("web-resource-collection");
            while (enum2.hasMoreElements()) {
                Element webResourceCollection = enum2.next();
                Elements enum3 = webResourceCollection.getElements("url-pattern");
                while (enum3.hasMoreElements()) {
                    String pattern = enum3.next().getString();
                    context.addGuard(pattern, new Role(roles));
                }
            }
        }
    }

    private void setLoginConfig(HTTPContext context) throws Exception {
        Element loginConfig = this.root.getElement("login-config");
        if (loginConfig == null) {
            return;
        }
        context.setAuthMethod(loginConfig.getString("auth-method"));
        String realmName = loginConfig.getString("realm-name");
        if (realmName != null) {
            IRealm realm = Realms.getRealm(realmName);
            if (realm == null) {
                throw new Exception("web.xml, <login-config> realm not found, check glue-config.xml for a realm declaration: " + realmName);
            }
            context.setRealm(Realms.getRealm(realmName));
        }
    }

    private void setSecurityRoles(HTTPContext context) {
        Elements elements = this.root.getElements("security-role");
        while (elements.hasMoreElements()) {
            elements.next();
        }
    }

    private void setListeners(HTTPContext context) {
    }
}

