/*
 * Decompiled with CFR 0.152.
 */
package electric.servlet.util;

import electric.glue.IGLUELoggingConstants;
import electric.util.array.ByteArray;
import electric.util.encoding.StringEncodings;
import electric.util.http.IHTTPConstants;
import electric.util.io.Streams;
import electric.util.log.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class HTTPServletUtil
implements IHTTPConstants,
IGLUELoggingConstants {
    private static int bufferSize = 2048;

    public static void setBufferSize(int bufferSize) {
        HTTPServletUtil.bufferSize = bufferSize;
    }

    public static int getBufferSize() {
        return bufferSize;
    }

    public static void writeContent(HttpServletRequest request, HttpServletResponse response, byte[] content) throws IOException {
        HTTPServletUtil.writeContent(request, response, new ByteArray(content));
    }

    public static void writeContent(HttpServletRequest request, HttpServletResponse response, ByteArray byteArray) throws IOException {
        response.setContentLength(byteArray.length);
        response.getOutputStream().write(byteArray.bytes, byteArray.offset, byteArray.length);
        if (Log.isLogging(IGLUELoggingConstants.HTTP_EVENT)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("response to ");
            if (request != null) {
                buffer.append(request.getRemoteHost());
            }
            buffer.append('\n');
            buffer.append(response);
            buffer.append(StringEncodings.fromProtocolEncoding(byteArray.bytes, byteArray.offset, byteArray.length));
            buffer.append('\n');
            Log.log(IGLUELoggingConstants.HTTP_EVENT, (Object)buffer.toString());
        }
    }

    public static void writeContent(HttpServletRequest request, HttpServletResponse response, InputStream input, int length) throws IOException {
        if (Log.isLogging(IGLUELoggingConstants.HTTP_EVENT)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("response to ");
            buffer.append(request.getRemoteHost());
            buffer.append('\n');
            buffer.append(response);
            buffer.append('\n');
            Log.log(IGLUELoggingConstants.HTTP_EVENT, (Object)buffer.toString());
        }
        response.setContentLength(length);
        Streams.copy(input, (OutputStream)response.getOutputStream(), length, bufferSize, IGLUELoggingConstants.HTTP_EVENT);
    }
}

