/*
 * Decompiled with CFR 0.152.
 */
package electric.servlet.sessions;

import electric.servlet.HTTPContext;
import electric.session.ISession;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;

public final class HTTPSession
implements HttpSession,
ISession {
    private static final Random random = new Random();
    private static long defaultTimeout = 300L;
    private String id;
    private long creationTime;
    private long lastAccessTime;
    private long timeout;
    private boolean invalidated;
    private Hashtable attributes = new Hashtable();
    private HTTPContext context;

    public HTTPSession(HTTPContext context) {
        this.context = context;
        this.creationTime = System.currentTimeMillis();
        this.id = Long.toString(Math.abs(random.nextLong()));
        this.setTimeout(HTTPSession.getDefaultTimeout());
    }

    public String toString() {
        return "HTTPSession( id=" + this.id + ", created=" + new Date(this.creationTime) + ", accessed=" + new Date(this.lastAccessTime) + ", timeout=" + this.timeout + ", invalidated=" + this.invalidated + " )";
    }

    public String getId() {
        return this.id;
    }

    public long getCreationTime() throws IllegalStateException {
        this.enforceValid();
        return this.creationTime;
    }

    public void setTimeout(int interval) {
        this.timeout = (long)interval * 1000L;
    }

    public void setMaxInactiveInterval(int interval) {
        this.setTimeout(interval);
    }

    public int getTimeout() {
        return (int)(this.timeout / 1000L);
    }

    public int getMaxInactiveInterval() {
        return this.getTimeout();
    }

    public boolean isNew() throws IllegalStateException {
        this.enforceValid();
        return this.lastAccessTime == 0L;
    }

    public long getLastAccessedTime() {
        return this.lastAccessTime;
    }

    public void accessed() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    public boolean expired() {
        if (this.timeout < 0L) {
            return false;
        }
        if (this.lastAccessTime == 0L) {
            return System.currentTimeMillis() - this.creationTime > this.timeout;
        }
        return System.currentTimeMillis() - this.lastAccessTime > this.timeout;
    }

    public static void setDefaultTimeout(int seconds) {
        defaultTimeout = (long)seconds * 1000L;
    }

    public static int getDefaultTimeout() {
        return (int)(defaultTimeout / 1000L);
    }

    public Object getAttribute(String name) throws IllegalStateException {
        this.enforceValid();
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() throws IllegalStateException {
        this.enforceValid();
        return this.attributes.keys();
    }

    public void setAttribute(String name, Object value) throws IllegalStateException {
        this.enforceValid();
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        this.attributes.put(name, value);
        if (value instanceof HttpSessionBindingListener) {
            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name);
            ((HttpSessionBindingListener)value).valueBound(event);
        }
    }

    public void removeAttribute(String name) throws IllegalStateException {
        this.enforceValid();
        Object value = this.attributes.remove(name);
        if (value instanceof HttpSessionBindingListener) {
            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name);
            ((HttpSessionBindingListener)value).valueUnbound(event);
        }
    }

    public Object getValue(String name) throws IllegalStateException {
        return this.getAttribute(name);
    }

    public void putValue(String name, Object value) throws IllegalStateException {
        this.setAttribute(name, value);
    }

    public void removeValue(String name) throws IllegalStateException {
        this.removeAttribute(name);
    }

    public String[] getValueNames() throws IllegalStateException {
        return null;
    }

    public synchronized void invalidate() throws IllegalStateException {
        this.enforceValid();
        Enumeration names = this.attributes.keys();
        while (names.hasMoreElements()) {
            this.removeAttribute((String)names.nextElement());
        }
        this.context.removeSession(this.id);
        this.invalidated = true;
    }

    private void enforceValid() throws IllegalStateException {
        if (this.invalidated) {
            throw new IllegalStateException("invalidated session");
        }
    }

    public boolean isValid() {
        return !this.invalidated;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }
}

