/*
 * Decompiled with CFR 0.152.
 */
package electric.servlet.filters;

import electric.servlet.Config;
import electric.servlet.filters.ServletFilterChain;
import electric.servlet.filters.ServletFilterConfig;
import electric.servlet.filters.ServletFilterMapping;
import java.util.Hashtable;
import java.util.Vector;

public class FilterMapper {
    private Vector filterMappingList = new Vector();
    private Hashtable filterConfigMap = new Hashtable();

    public void addFilterConfig(ServletFilterConfig config) {
        String name = config.getFilterName();
        if (name == null) {
            return;
        }
        if (this.getFilterConfig(name) != null) {
            return;
        }
        this.filterConfigMap.put(name, config);
    }

    public void addFilterMapping(String filterName, String servletName, String urlPattern) {
        ServletFilterConfig filterConfig = this.getFilterConfig(filterName);
        if (filterConfig == null) {
            return;
        }
        ServletFilterMapping filterMapping = new ServletFilterMapping(filterConfig, servletName, urlPattern);
        this.filterMappingList.addElement(filterMapping);
    }

    public ServletFilterConfig getFilterConfig(String filterName) {
        return (ServletFilterConfig)this.filterConfigMap.get(filterName);
    }

    public ServletFilterChain mapPathToFilters(Config servletConfig, String path) {
        if (this.filterMappingList.size() == 0) {
            return null;
        }
        Vector filters = new Vector();
        this.findServletNameMatches(servletConfig, filters);
        this.findURLMatches(path, filters);
        if (filters.size() == 0) {
            return null;
        }
        return new ServletFilterChain(servletConfig, filters);
    }

    private void findServletNameMatches(Config servletConfig, Vector filters) {
        int i = 0;
        while (i < this.filterMappingList.size()) {
            ServletFilterMapping map = (ServletFilterMapping)this.filterMappingList.elementAt(i);
            if (map.servletName != null && map.servletName.equals(servletConfig.getServletName())) {
                filters.addElement(map);
            }
            ++i;
        }
    }

    private void findURLMatches(String path, Vector filters) {
        int i = 0;
        while (i < this.filterMappingList.size()) {
            ServletFilterMapping map = (ServletFilterMapping)this.filterMappingList.elementAt(i);
            if (map.urlPattern != null) {
                if (map.urlPattern.equals(path)) {
                    filters.addElement(map);
                } else if (FilterMapper.matchPathPrefix(map, path)) {
                    filters.addElement(map);
                } else if (FilterMapper.matchExtension(map, path)) {
                    filters.addElement(map);
                } else if (map.urlPattern.equals("/")) {
                    filters.addElement(map);
                }
            }
            ++i;
        }
    }

    private static boolean matchPathPrefix(ServletFilterMapping map, String path) {
        if (!map.urlPattern.endsWith("/*")) {
            return false;
        }
        int slash = path.lastIndexOf(47);
        while (slash != -1) {
            String pathPrefix = path.substring(0, slash + 1) + "*";
            if (map.urlPattern.equals(pathPrefix)) {
                return true;
            }
            slash = path.lastIndexOf(47, slash - 1);
        }
        return false;
    }

    private static boolean matchExtension(ServletFilterMapping map, String path) {
        String extension;
        int dot = path.lastIndexOf(46);
        return dot >= 0 && map.urlPattern.equals(extension = "*." + path.substring(dot + 1));
    }
}

