/*
 * Decompiled with CFR 0.152.
 */
package electric.servlet.cookies;

import electric.util.array.ArrayUtil;
import electric.util.lex.Lex;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.Cookie;

final class Cookie0 {
    private static SimpleDateFormat dateFormatter;

    Cookie0() {
    }

    static Cookie[] getCookies(Lex lex) throws IOException {
        Cookie[] cookies = new Cookie[]{};
        while (true) {
            String key = lex.readToken();
            lex.readToken("=");
            String value = lex.readToken();
            cookies = (Cookie[])ArrayUtil.addElement(cookies, new Cookie(key, value));
            if (lex.eof()) break;
            lex.readToken(";");
        }
        return cookies;
    }

    static String toString(Cookie cookie) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(cookie.getName()).append('=').append(cookie.getValue());
        if (cookie.getMaxAge() >= 0) {
            Date date = new Date((long)(cookie.getMaxAge() * 1000) + System.currentTimeMillis());
            buffer.append("; expires=").append(Cookie0.format(date));
        }
        if (cookie.getPath() != null) {
            buffer.append("; path=").append(cookie.getPath());
        }
        if (cookie.getDomain() != null) {
            buffer.append("; domain=").append(cookie.getDomain());
        }
        if (cookie.getSecure()) {
            buffer.append("; secure");
        }
        return buffer.toString();
    }

    private static void initDateFormatter() {
        dateFormatter = new SimpleDateFormat("EEEEE, dd-MMM-yy HH:mm:ss z", Locale.US);
        dateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String format(Date date) {
        SimpleDateFormat simpleDateFormat = dateFormatter;
        synchronized (simpleDateFormat) {
            return dateFormatter.format(date);
        }
    }

    static {
        Cookie0.initDateFormatter();
    }
}

