/*
 * Decompiled with CFR 0.152.
 */
package electric.servlet.authenticators.digest;

import electric.glue.IGLUELoggingConstants;
import electric.security.IRealm;
import electric.security.credentials.DigestCredentials;
import electric.servlet.InboundHTTPRequest;
import electric.servlet.authenticators.IHTTPAuthenticator;
import electric.util.array.ArrayUtil;
import electric.util.http.AuthHeaderData;
import electric.util.http.DigestUtil;
import electric.util.http.IHTTPConstants;
import electric.util.io.Streams;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.string.Base64;
import electric.util.string.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DigestAuthenticator
implements IHTTPAuthenticator,
IHTTPConstants,
IGLUELoggingConstants {
    private String digestPrivateKey = "ELECTRIC";

    public String getAuthMethod() {
        return "DIGEST";
    }

    static void parseAuthHeader(String authHeader, AuthHeaderData authData) {
        int spacePos = authHeader.indexOf(" ");
        String authParams = authHeader.substring(spacePos);
        StringTokenizer tokenizer = new StringTokenizer(authParams, ",");
        while (tokenizer.hasMoreElements()) {
            String param = tokenizer.nextToken();
            int equalPos = param.indexOf("=");
            String name = param.substring(0, equalPos);
            name = name.trim();
            String value = param.substring(equalPos + 1);
            value = Strings.stripQuotes(value);
            if ("qop".equals(name)) {
                authData.qop = value;
                continue;
            }
            if ("realm".equals(name)) {
                authData.realmName = value;
                continue;
            }
            if ("nonce".equals(name)) {
                authData.nonce = value;
                continue;
            }
            if ("opaque".equals(name)) {
                authData.opaque = value;
                continue;
            }
            if ("username".equals(name)) {
                authData.userName = value;
                continue;
            }
            if ("uri".equals(name)) {
                authData.uri = value;
                continue;
            }
            if ("response".equals(name)) {
                authData.response = value;
                continue;
            }
            if ("cnonce".equals(name)) {
                authData.cnonce = value;
                continue;
            }
            if (!"nc".equals(name)) continue;
            authData.nc = value;
        }
    }

    public String[] getAuthorizedUsers(InboundHTTPRequest request, IRealm realm, String authHeader) {
        String[] users = new String[]{};
        AuthHeaderData authData = new AuthHeaderData();
        DigestAuthenticator.parseAuthHeader(authHeader, authData);
        try {
            if (!this.confirmNonce(authData.nonce)) {
                if (Log.isLogging(ILoggingConstants.SECURITY_EVENT)) {
                    Log.log(ILoggingConstants.SECURITY_EVENT, (Object)"confirmNonce failed");
                }
                return users;
            }
        }
        catch (NoSuchAlgorithmException exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "getAuthUsersDigest:", exception);
            }
            return users;
        }
        authData.httpMethod = request.getMethod();
        DigestCredentials digestCred = new DigestCredentials(authData);
        if (realm.authenticate(digestCred)) {
            request.setRemoteUser(authData.userName);
            users = (String[])ArrayUtil.addElement(users, authData.userName);
        }
        return users;
    }

    private String generateNonce() throws NoSuchAlgorithmException {
        String timeStamp = Long.toString(System.currentTimeMillis());
        MessageDigest digest = MessageDigest.getInstance("MD5");
        String hashPart = timeStamp + ":" + this.getDigestPrivateKey();
        byte[] hashDigest = digest.digest(hashPart.getBytes());
        String hashedString = DigestUtil.digestHexFormat(hashDigest);
        String rawNonce = timeStamp + ":" + hashedString;
        return Base64.toBase64(rawNonce.getBytes());
    }

    private boolean confirmNonce(String nonce) throws NoSuchAlgorithmException {
        byte[] rawNonceBytes = Base64.fromBase64(nonce);
        String rawNonce = new String(rawNonceBytes);
        int colonPos = rawNonce.indexOf(":");
        if (colonPos == -1) {
            if (Log.isLogging(ILoggingConstants.SECURITY_EVENT)) {
                Log.log(ILoggingConstants.SECURITY_EVENT, (Object)"confirmNonce failed, bad digest");
            }
            return false;
        }
        String timeStamp = rawNonce.substring(0, colonPos);
        String hashPartDigestIn = rawNonce.substring(colonPos + 1);
        MessageDigest digest = MessageDigest.getInstance("MD5");
        String hashPart = timeStamp + ":" + this.getDigestPrivateKey();
        byte[] hashPartBytes = digest.digest(hashPart.getBytes());
        String hashPartDigest = DigestUtil.digestHexFormat(hashPartBytes);
        return hashPartDigest.equals(hashPartDigestIn);
    }

    public String getDigestPrivateKey() {
        return this.digestPrivateKey;
    }

    public boolean requestAuthentication(HttpServletRequest request, HttpServletResponse response, IRealm realm) throws IOException {
        block3: {
            if (request.getContentLength() != -1) {
                Streams.readFully((InputStream)request.getInputStream(), request.getContentLength());
            }
            response.setStatus(401);
            String realmName = realm == null ? "null" : realm.getName();
            try {
                String authHeader = "Digest ";
                authHeader = authHeader + "realm=\"" + realmName + "\"";
                authHeader = authHeader + ", ";
                authHeader = authHeader + "qop=\"auth\"";
                authHeader = authHeader + ", ";
                authHeader = authHeader + "nonce=\"" + this.generateNonce() + "\"";
                response.addHeader("WWW-Authenticate", authHeader);
                response.setContentLength(0);
            }
            catch (NoSuchAlgorithmException exception) {
                if (!Log.isLogging(ILoggingConstants.SECURITY_EVENT)) break block3;
                Log.log(ILoggingConstants.SECURITY_EVENT, (Object)("requestAuthenticationDigest got exception:" + exception));
            }
        }
        return false;
    }
}

