/*
 * Decompiled with CFR 0.152.
 */
package electric.servlet;

import electric.net.channel.IChannel;
import electric.servlet.HTTPError;
import electric.servlet.InboundHTTPRequest;
import electric.servlet.cookies.Cookies;
import electric.servlet.streams.BufferedServletOutput;
import electric.servlet.streams.ServletOutput;
import electric.util.encoding.StringEncodings;
import electric.util.encoding.XMLEncodings;
import electric.util.http.IHTTPConstants;
import electric.util.mime.MIMEHeaders;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class OutboundHTTPResponse
implements HttpServletResponse,
IHTTPConstants {
    private IChannel channel;
    private String version = "HTTP/1.1";
    private int status = 200;
    private String message = "OK";
    private MIMEHeaders headers = new MIMEHeaders();
    private int bufferSize;
    private ServletOutputStream outputStream;
    private PrintWriter writer = null;
    private boolean flushedHeaders = false;
    private boolean committed = false;
    private String encoding = "ISO-8859-1";

    public OutboundHTTPResponse() {
    }

    public OutboundHTTPResponse(InboundHTTPRequest request) {
        this.channel = request.getChannel();
        request.setHTTPResponse(this);
        this.setKeepAlive(request);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.version).append(' ').append(this.status).append(' ').append(this.message).append('\n');
        buffer.append(this.headers.toString());
        return buffer.toString();
    }

    public IChannel getChannel() {
        return this.channel;
    }

    public void setChannel(IChannel channel) {
        this.channel = channel;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public int getContentLength() {
        return this.headers.getContentLength();
    }

    public void setContentLength(int length) {
        this.headers.setContentLength(length);
    }

    public synchronized void setContentType(String type) {
        this.headers.setContentType(type);
        String contentTypeEncoding = this.headers.getCharacterEncoding();
        if (contentTypeEncoding != null) {
            this.encoding = contentTypeEncoding;
        }
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public void flushHeaders() throws IOException {
        if (this.flushedHeaders) {
            return;
        }
        this.writeHeaders();
        this.flushedHeaders = true;
    }

    public void writeHeaders() throws IOException {
        OutputStream output = this.channel.getOutputStream();
        output.write(StringEncodings.toProtocolEncoding(this.version));
        output.write(32);
        output.write(StringEncodings.toProtocolEncoding(Integer.toString(this.status)));
        output.write(32);
        output.write(StringEncodings.toProtocolEncoding(this.message));
        output.write(IHTTPConstants.EOL);
        this.headers.writeHeaders(output);
        output.write(IHTTPConstants.EOL);
    }

    public MIMEHeaders getHeaders() {
        return this.headers;
    }

    public void clearHeaders() {
        this.headers.clearHeaders();
    }

    public String getHeader(String name) {
        return this.headers.getHeader(name);
    }

    public boolean containsHeader(String name) {
        return this.headers.containsHeader(name);
    }

    public void setHeader(String name, String value) {
        this.headers.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this.headers.addHeader(name, value);
    }

    public int getIntHeader(String name) {
        return this.headers.getIntHeader(name);
    }

    public void setIntHeader(String name, int value) {
        this.headers.setIntHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.headers.addIntHeader(name, value);
    }

    public void setDateHeader(String name, long date) {
        this.headers.setDateHeader(name, date);
    }

    public void addDateHeader(String name, long date) {
        this.headers.addDateHeader(name, date);
    }

    public Enumeration getLocales() {
        return null;
    }

    public void setLocale(Locale locale) {
        this.setHeader("Content-Language", locale.toString());
    }

    public Locale getLocale() {
        return (Locale)this.getLocales().nextElement();
    }

    public void reset() throws IllegalStateException {
        this.resetBuffer();
        this.clearHeaders();
    }

    public void resetBuffer() throws IllegalStateException {
        if (this.committed) {
            throw new IllegalStateException("cannot reset after flush");
        }
        if (this.outputStream instanceof BufferedServletOutput) {
            ((BufferedServletOutput)this.outputStream).resetBuffer();
        }
    }

    public void flushBuffer() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
        } else if (this.writer != null) {
            this.writer.flush();
        } else {
            this.flushHeaders();
            this.channel.getOutputStream().flush();
        }
        this.committed = true;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        if (this.writer != null) {
            throw new IllegalStateException("cannot set buffer once writer has been obtained");
        }
        if (this.outputStream != null) {
            throw new IllegalStateException("cannot set buffer once output stream has been obtained");
        }
        this.bufferSize = bufferSize;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.setStatus(status, HTTPError.getStatusMessage(status));
    }

    public void setStatus(int status, String message) {
        this.status = status;
        this.message = message;
    }

    public void sendError(int status) {
        this.sendError(status, HTTPError.getStatusMessage(status));
    }

    public void sendError(int status, String message) {
        this.setStatus(status, message);
        this.message = message;
    }

    public void addCookie(Cookie cookie) {
        if (cookie.getVersion() == 0) {
            this.addHeader("Set-Cookie", Cookies.toString(cookie));
        } else {
            this.addHeader("Set-Cookie2", Cookies.toString(cookie));
        }
    }

    public void setKeepAlive(InboundHTTPRequest request) {
        if (request.getVersion().equals("HTTP/1.0") && request.isKeepAlive()) {
            this.setHeader("Connection", "Keep-Alive");
        }
    }

    public String encodeRedirectURL(String url) {
        return null;
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public void sendRedirect(String location) throws IOException {
        this.setStatus(302);
        this.setHeader("Location", location);
        byte[] bytes = StringEncodings.toProtocolEncoding("redirect to <a href=\"" + location + "\"/>");
        this.setContentLength(bytes.length);
        this.getOutputStream().write(bytes);
        this.flushBuffer();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.outputStream != null) {
            return this.outputStream;
        }
        if (this.writer != null) {
            throw new IllegalStateException("getWriter already called on this ServletResponse");
        }
        OutputStream output = this.channel.getOutputStream();
        this.outputStream = this.bufferSize == 0 ? new ServletOutput(this, output) : new BufferedServletOutput((OutputStream)((Object)new ServletOutput(this, output)), this.bufferSize);
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.outputStream != null) {
            throw new IllegalStateException("getOutputStream already called on this ServletResponse");
        }
        ServletOutput outputStream = new ServletOutput(this, this.channel.getOutputStream());
        if (this.encoding == null) {
            this.encoding = "ISO-8859-1";
        }
        this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)outputStream), XMLEncodings.getXMLEncoding(this.encoding)));
        return this.writer;
    }

    public void resetStreams() throws IOException {
        if (!this.isCommitted()) {
            this.reset();
        }
        this.outputStream = null;
        this.writer = null;
    }
}

