/*
 * Decompiled with CFR 0.152.
 */
package electric.service.reference;

import electric.proxy.IReference;
import electric.proxy.chain.ReferenceChain;
import electric.service.IService;
import electric.service.reference.IReferenceFactory;
import electric.util.array.ArrayUtil;

public class ReferenceFactories {
    private static IReferenceFactory[] factories = new IReferenceFactory[0];

    public static void addFactory(IReferenceFactory factory) {
        factories = (IReferenceFactory[])ArrayUtil.addElement(factories, factory);
    }

    public static void insertFactoryAt(IReferenceFactory factory, int index) {
        factories = (IReferenceFactory[])ArrayUtil.insertElementAt(factories, factory, index);
    }

    public static void removeFactory(IReferenceFactory factory) {
        factories = (IReferenceFactory[])ArrayUtil.removeElement(factories, factory);
    }

    public static void removeFactory(Class factoryClass) {
        int i = 0;
        while (i < factories.length) {
            if (factoryClass.isAssignableFrom(factories[i].getClass())) {
                ReferenceFactories.removeFactory(factories[i]);
                break;
            }
            ++i;
        }
    }

    public static IReference getReferenceChain(IService service, IReference lastReference) {
        if (factories.length == 0) {
            return lastReference;
        }
        ReferenceChain chain = new ReferenceChain();
        int i = 0;
        while (i < factories.length) {
            chain.addReference(factories[i].newReference(service));
            ++i;
        }
        chain.addReference(lastReference);
        return chain;
    }

    public static IReference getReferenceOfType(IService service, Class type) {
        IReference reference = service.getReference();
        if (reference instanceof ReferenceChain) {
            return ((ReferenceChain)reference).getReferenceOfType(type);
        }
        return null;
    }
}

