/*
 * Decompiled with CFR 0.152.
 */
package electric.service.instrumentation;

import electric.service.instrumentation.MethodInstrumentationInfo;
import java.util.Hashtable;

public class Instrumentor {
    private long failures;
    private long successes;
    private Hashtable methods = new Hashtable();

    public void addFailure() {
        ++this.failures;
    }

    public void addSuccess() {
        ++this.successes;
    }

    public long getTotalFailures() {
        return this.failures;
    }

    public long getTotalSuccesses() {
        return this.successes;
    }

    public long getTotalRequests() {
        return this.failures + this.successes;
    }

    public void startTiming(String method, int args) {
        MethodInstrumentationInfo instrInfo = this.getMethodInstrInfo(method, args);
        if (instrInfo == null) {
            instrInfo = new MethodInstrumentationInfo();
            this.methods.put(this.getMethodId(method, args), instrInfo);
        }
        instrInfo.startTiming();
    }

    public void stopTiming(String method, int args) {
        MethodInstrumentationInfo instrInfo = this.getMethodInstrInfo(method, args);
        instrInfo.stopTiming();
    }

    public long getFastestExecution(String method, int args) {
        MethodInstrumentationInfo instrInfo = this.getMethodInstrInfo(method, args);
        if (instrInfo == null) {
            return -1L;
        }
        return instrInfo.getFastest();
    }

    public long getSlowestExecution(String method, int args) {
        MethodInstrumentationInfo instrInfo = this.getMethodInstrInfo(method, args);
        if (instrInfo == null) {
            return -1L;
        }
        return instrInfo.getSlowest();
    }

    public long getLastExecution(String method, int args) {
        MethodInstrumentationInfo instrInfo = this.getMethodInstrInfo(method, args);
        if (instrInfo == null) {
            return -1L;
        }
        return instrInfo.getLast();
    }

    public long getAverageExecution(String method, int args) {
        MethodInstrumentationInfo instrInfo = this.getMethodInstrInfo(method, args);
        if (instrInfo == null) {
            return -1L;
        }
        return instrInfo.getAverage();
    }

    public long getExecutionsPerUnitOfTime(String method, int args, int unitoftime) {
        MethodInstrumentationInfo instrInfo = this.getMethodInstrInfo(method, args);
        if (instrInfo == null) {
            return -1L;
        }
        return instrInfo.getExecutionsPerUnitOfTime(unitoftime);
    }

    public long getTotalExecutions(String method, int args) {
        MethodInstrumentationInfo instrInfo = this.getMethodInstrInfo(method, args);
        if (instrInfo == null) {
            return -1L;
        }
        return instrInfo.getTotal();
    }

    private MethodInstrumentationInfo getMethodInstrInfo(String method, int args) {
        return (MethodInstrumentationInfo)this.methods.get(this.getMethodId(method, args));
    }

    private String getMethodId(String method, int args) {
        return method + "-" + args;
    }
}

