/*
 * Decompiled with CFR 0.152.
 */
package electric.server.jms;

import electric.server.jms.IJMSAdapter;
import electric.server.jms.IJMSConstants;
import electric.server.jms.JMS;
import electric.util.Context;
import electric.util.jms.JMSUtil;
import electric.util.log.Log;
import electric.util.resourceloader.IResourceLoader;
import electric.util.string.Strings;
import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;

public class JMSResourceLoader
implements IResourceLoader,
IJMSConstants {
    public byte[] loadResource(String path, Context context) throws IOException {
        Queue queue;
        QueueConnectionFactory factory;
        path = Strings.head(path, '.');
        String servicePath = Strings.getEndpoint(path.substring(6));
        String requestQueueName = (String)Context.getProperty(context, "jmsQueue");
        String queueFactory = (String)Context.getProperty(context, "jmsQueueConnectionFactory");
        IJMSAdapter jmsAdapter = JMS.getAdapter();
        try {
            jmsAdapter.startup(context);
        }
        catch (Exception exception) {
            throw new IOException("unable to initialize JMS adapter for " + jmsAdapter.getProviderName());
        }
        if (requestQueueName == null) {
            requestQueueName = Context.getSystemProperty("jmsQueue");
        }
        if (queueFactory == null) {
            queueFactory = Context.getSystemProperty("jmsQueueConnectionFactory");
        }
        if (servicePath.equals("")) {
            servicePath = "/";
        }
        String[] admObjects = JMS.findAdminObjects(requestQueueName, queueFactory, servicePath);
        try {
            factory = jmsAdapter.getQueueConnectionFactory(admObjects[0], false);
            queue = jmsAdapter.getQueue(admObjects[1], false);
        }
        catch (Exception exception) {
            throw new IOException("unable to lookup jms administered objects - " + exception.toString());
        }
        try {
            BytesMessage message;
            block12: {
                QueueConnection conn = factory.createQueueConnection();
                conn.start();
                QueueSession session = conn.createQueueSession(false, 1);
                message = session.createBytesMessage();
                message.setStringProperty("wsdlRequest", path);
                QueueSender sender = session.createSender(queue);
                message.setJMSReplyTo((Destination)queue);
                sender.send((Message)message);
                QueueReceiver receiver = session.createReceiver(queue, "JMSCorrelationID = '" + message.getJMSMessageID() + "'");
                message = (BytesMessage)receiver.receive();
                sender.close();
                receiver.close();
                session.close();
                conn.close();
                try {
                    JMSUtil.cleanup();
                }
                catch (Exception exception) {
                    if (!Log.isLogging("ERROR")) break block12;
                    Log.log("ERROR", (Object)"error while closing initial context");
                }
            }
            if (message.propertyExists("wsdlNotFound")) {
                throw new IOException("unable to find WSDL for " + path);
            }
            return JMSUtil.getMessageBytes(message);
        }
        catch (JMSException exception) {
            exception.printStackTrace();
            throw new IOException("unable to read WSDL file " + path + " over JMS queue");
        }
    }
}

