/*
 * Decompiled with CFR 0.152.
 */
package electric.security.jaas;

import electric.glue.IGLUELoggingConstants;
import electric.security.ICredentials;
import electric.security.IRealm;
import electric.security.basic.BasicPrincipal;
import electric.security.credentials.PasswordCredentials;
import electric.util.array.ArrayUtil;
import electric.util.classloader.ClassLoaders;
import electric.util.license.Enabler;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.path.Paths;
import electric.util.product.Product;
import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;

public class JAASRealm
implements IRealm,
IGLUELoggingConstants {
    private static boolean enabled = false;
    private static boolean allowEnable = true;
    private String realmName;
    private HashMap nameToPrincipal = new HashMap();
    private HashMap nameToSubject = new HashMap();
    private HashMap promptsToResponses = new HashMap();
    private Class principalClass;

    public JAASRealm(String realmName) {
        this.realmName = realmName;
        if (!enabled) {
            throw new IllegalStateException("JAAS is available for GLUE Professional only");
        }
        if (System.getSecurityManager() == null) {
            throw new SecurityException("Cannot create JAAS realm without a Java2 Security Manager in place");
        }
    }

    public JAASRealm(String realmName, String jaasConfig) {
        this.realmName = realmName;
        if (!enabled) {
            throw new IllegalStateException("JAAS is available for GLUE Professional only");
        }
        if (System.getSecurityManager() == null) {
            throw new SecurityException("Cannot create JAAS realm without a Java2 Security Manager in place");
        }
        try {
            System.setProperty("java.security.auth.login.config", Paths.normalizePath(jaasConfig));
        }
        catch (SecurityException exception) {
            if (Log.isLogging(ILoggingConstants.SECURITY_EVENT)) {
                Log.log(ILoggingConstants.SECURITY_EVENT, (Object)"JAAS Realm cannot be created.  No permission to access the property \"java.security.auth.login.config\"");
            }
            throw exception;
        }
    }

    public JAASRealm(String realmName, String jaasConfig, String className) throws ClassNotFoundException {
        this(realmName, jaasConfig);
        this.setPrincipalClass(ClassLoaders.loadClass(className));
    }

    public String getName() {
        return this.realmName;
    }

    public Principal getPrincipal(String user) {
        return (Principal)this.nameToPrincipal.get(user);
    }

    public String getPassword(String user) {
        return null;
    }

    public String[] getRoles(String user) {
        String[] roles = new String[]{};
        Subject subject = (Subject)this.nameToSubject.get(user);
        if (subject == null || this.principalClass == null) {
            return roles;
        }
        Iterator iter = subject.getPrincipals(this.principalClass).iterator();
        while (iter.hasNext()) {
            roles = (String[])ArrayUtil.addElement(roles, ((Principal)iter.next()).getName());
        }
        return roles;
    }

    public boolean isUserInRole(String user, String[] roles) {
        String[] userRoles = this.getRoles(user);
        int i = 0;
        while (i < userRoles.length) {
            int j = 0;
            while (j < roles.length) {
                if (userRoles[i].equals(roles[j])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public void addCallback(String prompt, String response) {
        this.promptsToResponses.put(prompt, response);
    }

    public void setPrincipalClass(Class principal) {
        this.principalClass = principal;
    }

    public boolean authenticate(ICredentials credentials) throws SecurityException {
        if (credentials != null) {
            if (credentials instanceof PasswordCredentials) {
                return this.authenticateBasic((PasswordCredentials)credentials);
            }
            throw new SecurityException("JAASRealm requires PasswordCredentials");
        }
        return false;
    }

    public boolean authenticateBasic(PasswordCredentials credentials) {
        try {
            String user = credentials.getUserName();
            Subject subject = (Subject)this.nameToSubject.get(user);
            if (subject == null) {
                subject = new Subject();
            }
            MyCallbackHandler myCallback = new MyCallbackHandler(user, credentials.password);
            myCallback.promptsToTextInput = this.promptsToResponses;
            LoginContext lc = new LoginContext(this.getName(), subject, myCallback);
            lc.login();
            this.nameToSubject.put(user, subject);
            Iterator<Principal> principals = subject.getPrincipals().iterator();
            while (principals.hasNext()) {
                Principal current = principals.next();
                if (!current.getName().equals(user)) continue;
                this.nameToPrincipal.put(user, current);
                return true;
            }
            this.nameToPrincipal.put(user, new BasicPrincipal(user));
            return true;
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.SECURITY_EVENT)) {
                Log.log(ILoggingConstants.SECURITY_EVENT, (Throwable)exception);
            }
            return false;
        }
    }

    public static void enable() {
        if (enabled) {
            return;
        }
        if (!allowEnable) {
            throw new IllegalStateException("JAAS cannot be enabled once it is disabled");
        }
        enabled = Enabler.enable();
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void disable() {
        enabled = false;
        allowEnable = false;
        Log.log(ILoggingConstants.WARNING_EVENT, (Object)"JAAS integration feature disabled");
    }

    static {
        Product.startup();
    }

    class MyCallbackHandler
    implements CallbackHandler {
        private String user;
        private String password;
        private HashMap promptsToTextInput = new HashMap();

        public MyCallbackHandler(String user, String password) {
            this.user = user;
            this.password = password;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            int i = 0;
            while (i < callbacks.length) {
                Callback callback = callbacks[i];
                if (callback instanceof NameCallback) {
                    if (Log.isLogging(IGLUELoggingConstants.SECURITY_DEBUG_EVENT)) {
                        Log.log(IGLUELoggingConstants.SECURITY_DEBUG_EVENT, (Object)((NameCallback)callback).getPrompt());
                    }
                    ((NameCallback)callback).setName(this.user);
                } else if (callback instanceof PasswordCallback) {
                    if (Log.isLogging(IGLUELoggingConstants.SECURITY_DEBUG_EVENT)) {
                        Log.log(IGLUELoggingConstants.SECURITY_DEBUG_EVENT, (Object)((PasswordCallback)callback).getPrompt());
                    }
                    ((PasswordCallback)callback).setPassword(this.password.toCharArray());
                } else if (callback instanceof TextOutputCallback) {
                    if (Log.isLogging(IGLUELoggingConstants.SECURITY_DEBUG_EVENT)) {
                        Log.log(IGLUELoggingConstants.SECURITY_DEBUG_EVENT, (Object)((TextOutputCallback)callback).getMessage());
                    }
                } else if (callback instanceof TextInputCallback) {
                    String output;
                    String prompt = ((TextInputCallback)callback).getPrompt();
                    if (Log.isLogging(IGLUELoggingConstants.SECURITY_DEBUG_EVENT)) {
                        Log.log(IGLUELoggingConstants.SECURITY_DEBUG_EVENT, (Object)("TextInputCallback with the prompt: {" + prompt + "}"));
                    }
                    if ((output = (String)this.promptsToTextInput.get(prompt)) == null) {
                        throw new UnsupportedCallbackException(callback);
                    }
                    ((TextInputCallback)callback).setText(output);
                } else {
                    throw new UnsupportedCallbackException(callback);
                }
                ++i;
            }
        }
    }
}

