/*
 * Decompiled with CFR 0.152.
 */
package electric.registry.directory;

import electric.directory.Directory;
import electric.directory.DirectoryException;
import electric.directory.IDirectory;
import electric.proxy.IReference;
import electric.registry.IRegistry;
import electric.registry.RegistryException;
import electric.service.IService;
import electric.util.Context;
import electric.util.XURL;
import electric.util.classloader.ClassLoaders;
import electric.util.classloader.IHasClassLoader;
import electric.wsdl.IWSDLConstants;

public class DirectoryRegistry
implements IRegistry,
IWSDLConstants {
    private IDirectory directory;

    public DirectoryRegistry() {
        this.directory = new Directory();
    }

    public DirectoryRegistry(IDirectory directory) {
        this.directory = directory;
    }

    public void setDirectory(String path, IDirectory directory) throws DirectoryException {
        if (path.equals("/")) {
            this.directory = directory;
        } else {
            this.directory.put(path, directory);
        }
    }

    public IDirectory getDirectory() {
        return this.directory;
    }

    public IDirectory getDirectory(String path) throws DirectoryException {
        return (IDirectory)this.directory.get(path);
    }

    public Object get(String path) throws RegistryException {
        try {
            return this.directory.get(path);
        }
        catch (DirectoryException exception) {
            throw new RegistryException(exception);
        }
    }

    public IReference bind(String path, Class[] interfaces, Context context) throws RegistryException {
        ClassLoader cl;
        if (path == null || path.startsWith("?") || XURL.hasProtocol(path)) {
            return null;
        }
        Object object = this.get(path);
        IReference reference = null;
        if (object instanceof IHasClassLoader && !ClassLoaders.isAncestor(cl = ((IHasClassLoader)object).getClassLoader(), ClassLoaders.getContextClassLoader())) {
            return null;
        }
        if (object instanceof IService) {
            reference = ((IService)object).getReference();
        }
        return reference;
    }

    public boolean publish(String path, Object object, Context context) throws RegistryException {
        if (XURL.hasProtocol(path)) {
            return false;
        }
        try {
            this.directory.put(path, object);
            return true;
        }
        catch (DirectoryException exception) {
            throw new RegistryException(exception);
        }
    }

    public boolean unpublish(String path) throws RegistryException {
        if (XURL.hasProtocol(path)) {
            return false;
        }
        try {
            this.directory.remove(path);
            return true;
        }
        catch (DirectoryException exception) {
            throw new RegistryException(exception);
        }
    }
}

