/*
 * Decompiled with CFR 0.152.
 */
package electric.net.socket;

import electric.net.channel.IChannel;
import electric.net.channel.IChannelListener;
import electric.util.XURL;
import electric.util.io.MonitoringInputStream;
import electric.util.io.MonitoringOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;

public class SocketChannel
implements IChannel {
    private static int defaultTimeout = 0;
    private static int defaultBufferSize = 8192;
    private static boolean instrumentChannel = false;
    private Socket socket;
    private InputStream input;
    private MonitoringInputStream inMonitor;
    private OutputStream output;
    private MonitoringOutputStream outMonitor;
    private XURL localXURL;
    private XURL remoteXURL;
    private int state;
    private boolean keepAlive = false;
    private boolean keptAlive = false;
    private IChannelListener shutdownListener;

    public SocketChannel(Socket socket, String protocol) throws IOException {
        this(socket, protocol, null);
    }

    public SocketChannel(Socket socket, String protocol, IChannelListener shutdownListener) throws IOException {
        this.socket = socket;
        this.shutdownListener = shutdownListener;
        if (instrumentChannel) {
            this.inMonitor = new MonitoringInputStream(socket.getInputStream());
            this.outMonitor = new MonitoringOutputStream(socket.getOutputStream());
            this.input = new BufferedInputStream(this.inMonitor, defaultBufferSize);
            this.output = new BufferedOutputStream(this.outMonitor, defaultBufferSize);
        } else {
            this.input = new BufferedInputStream(socket.getInputStream(), defaultBufferSize);
            this.output = new BufferedOutputStream(socket.getOutputStream(), defaultBufferSize);
        }
        this.localXURL = this.asXURL(protocol, socket.getLocalAddress(), socket.getLocalPort());
        this.remoteXURL = this.asXURL(protocol, socket.getInetAddress(), socket.getPort());
        this.setTimeout(defaultTimeout);
    }

    public String toString() {
        return "SocketChannel( localXURL=" + this.localXURL + ", removeXURL=" + this.remoteXURL + " )";
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setTimeout(int milliseconds) throws IOException {
        this.socket.setSoTimeout(milliseconds);
    }

    public int getTimeout() throws IOException {
        return this.socket.getSoTimeout();
    }

    public InputStream getInputStream() throws IOException {
        return this.input;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.output;
    }

    public void close() throws IOException {
        this.keepAlive = false;
        try {
            if (this.shutdownListener != null) {
                this.shutdownListener.channelShutdown(this);
            }
            this.socket.close();
        }
        catch (Exception exception) {}
    }

    public XURL getLocalXURL() {
        return this.localXURL;
    }

    public XURL getRemoteXURL() {
        return this.remoteXURL;
    }

    public long getBytesRead() {
        return this.inMonitor != null ? this.inMonitor.getBytesRead() : -1L;
    }

    public long getBytesWritten() {
        return this.outMonitor != null ? this.outMonitor.getBytesWritten() : -1L;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeptAlive(boolean keptAlive) {
        this.keptAlive = keptAlive;
    }

    public boolean getKeptAlive() {
        return this.keptAlive;
    }

    public static void setDefaultTimeout(int milliseconds) {
        defaultTimeout = milliseconds;
    }

    public static int getDefaultTimeout() {
        return defaultTimeout;
    }

    public static void setDefaultBufferSize(int bufferSize) {
        defaultBufferSize = bufferSize;
    }

    public static int getDefaultBufferSize() {
        return defaultBufferSize;
    }

    private XURL asXURL(String protocol, InetAddress address, int port) {
        return new XURL(protocol, address.getHostAddress(), port, null, null);
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public static void needInstrumentation(boolean instrumentChannel) {
        SocketChannel.instrumentChannel = instrumentChannel;
    }
}

