/*
 * Decompiled with CFR 0.152.
 */
package electric.net.event;

import electric.glue.IGLUEContextConstants;
import electric.net.event.INetEventConstants;
import electric.net.event.INetEventListener;
import electric.net.event.NetEvent;
import electric.net.event.NetEventReaper;
import electric.util.Context;
import electric.util.XURL;
import electric.util.array.ArrayUtil;
import electric.util.thread.Tasks;
import java.util.Enumeration;
import java.util.Vector;

public final class NetLog
implements IGLUEContextConstants,
INetEventConstants {
    private static long reapCycle;
    private static long expiryPeriod;
    private static long retryPeriod;
    private static Vector events;
    private static INetEventListener[] listeners;

    public static long getRetryPeriod() {
        return retryPeriod;
    }

    public static synchronized void addListener(INetEventListener listener) {
        listeners = (INetEventListener[])ArrayUtil.addElement(listeners, listener);
    }

    public static synchronized void removeListener(INetEventListener listener) {
        listeners = (INetEventListener[])ArrayUtil.removeElement(listeners, listener);
    }

    public static synchronized void addEvent(NetEvent event) {
        events.addElement(event);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].addedEvent(event);
            ++i;
        }
    }

    public static Enumeration getEvents(XURL endpoint) {
        Vector<NetEvent> matches = new Vector<NetEvent>();
        int i = 0;
        while (i < events.size()) {
            NetEvent event = (NetEvent)events.elementAt(i);
            if (event.matches(endpoint)) {
                matches.addElement(event);
            }
            ++i;
        }
        return matches.elements();
    }

    public static NetEvent getEvent(XURL endpoint) {
        int i = 0;
        while (i < events.size()) {
            NetEvent event = (NetEvent)events.elementAt(i);
            if (event.matches(endpoint)) {
                return event;
            }
            ++i;
        }
        return null;
    }

    public static boolean hasEvents(XURL endpoint) {
        return NetLog.getEvent(endpoint) != null;
    }

    public static synchronized void removeEvents(XURL endpoint) {
        int i = 0;
        while (i < events.size()) {
            NetEvent event = (NetEvent)events.elementAt(i);
            if (event.matches(endpoint)) {
                events.removeElementAt(i);
                int j = 0;
                while (j < listeners.length) {
                    listeners[j].removedEvent(event);
                    ++j;
                }
                continue;
            }
            ++i;
        }
    }

    public static synchronized void removeEvent(NetEvent event) {
        boolean removed = events.removeElement(event);
        if (removed) {
            int i = 0;
            while (i < listeners.length) {
                listeners[i].removedEvent(event);
                ++i;
            }
        }
    }

    public static synchronized void clearEvents() {
        events = new Vector();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].clearedEvents();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reap() {
        Enumeration enumeration;
        long currentTime = System.currentTimeMillis();
        Vector<NetEvent> expiredEvents = new Vector<NetEvent>();
        Vector vector = events;
        synchronized (vector) {
            enumeration = events.elements();
            while (enumeration.hasMoreElements()) {
                NetEvent event = (NetEvent)enumeration.nextElement();
                if (currentTime - event.getTime() <= expiryPeriod) continue;
                expiredEvents.addElement(event);
            }
        }
        enumeration = expiredEvents.elements();
        while (enumeration.hasMoreElements()) {
            NetLog.removeEvent((NetEvent)enumeration.nextElement());
        }
    }

    static {
        events = new Vector();
        listeners = new INetEventListener[0];
        reapCycle = Context.application().getIntProperty("netEventReaperCycle", 60000);
        expiryPeriod = Context.application().getIntProperty("netEventReaperExpiryPeriod", 300000);
        retryPeriod = Context.application().getIntProperty("netEventRetryPeriod", 60000);
        NetEventReaper reaper = new NetEventReaper();
        Tasks.getShared().runAfter(reaper, reapCycle, "net event reaper", reapCycle, false);
    }
}

