/*
 * Decompiled with CFR 0.152.
 */
package electric.jaxrpc;

import electric.jaxrpc.CallImpl;
import electric.jaxrpc.StubImpl;
import electric.proxy.IReference;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.util.Context;
import electric.wsdl.Port;
import electric.wsdl.Service;
import electric.wsdl.WSDL;
import electric.wsdl.loader.WSDLLoader;
import electric.xml.io.schema.SchemaException;
import java.net.URL;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerRegistry;

public final class ServiceImpl
implements javax.xml.rpc.Service {
    private URL wsdlDocumentLocation;
    private WSDL wsdl;
    private Service service;
    private QName serviceName;
    private IReference reference;
    static /* synthetic */ Class class$java$rmi$Remote;

    public ServiceImpl(QName serviceName) throws ServiceException {
        this.serviceName = serviceName;
    }

    public ServiceImpl(URL wsdlDocumentLocation, QName serviceName) throws ServiceException {
        this.wsdlDocumentLocation = wsdlDocumentLocation;
        this.serviceName = serviceName;
        try {
            this.wsdl = WSDLLoader.getWSDL(wsdlDocumentLocation.toString());
            this.service = this.getService();
        }
        catch (Exception exception) {
            throw new ServiceException(exception.getMessage(), (Throwable)exception);
        }
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    private Service getService() throws SchemaException {
        if (this.serviceName == null) {
            return null;
        }
        if (this.serviceName.getNamespaceURI().length() == 0) {
            return this.wsdl.getService(this.serviceName.getLocalPart());
        }
        return this.wsdl.getService(this.serviceName.getNamespaceURI() + ":" + this.serviceName.getLocalPart());
    }

    public URL getWSDLDocumentLocation() {
        return this.wsdlDocumentLocation;
    }

    public Remote getPort(Class serviceEndpointInterface) throws ServiceException {
        Class[] types = null;
        types = (class$java$rmi$Remote == null ? (class$java$rmi$Remote = ServiceImpl.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(serviceEndpointInterface) ? new Class[]{serviceEndpointInterface} : new Class[]{serviceEndpointInterface, class$java$rmi$Remote == null ? (class$java$rmi$Remote = ServiceImpl.class$("java.rmi.Remote")) : class$java$rmi$Remote};
        StubImpl stub = new StubImpl(this.getReference());
        return (Remote)Registry.newProxy(stub, types);
    }

    public Remote getPort(QName portName, Class serviceEndpointInterface) throws ServiceException {
        return this.getPort(serviceEndpointInterface);
    }

    public Iterator getPorts() throws ServiceException {
        if (this.wsdl == null) {
            throw new ServiceException("cannot access port info without WSDL URL");
        }
        Port[] ports = this.service.getPorts();
        ArrayList<QName> portNames = new ArrayList<QName>();
        int i = 0;
        while (i < ports.length) {
            portNames.add(new QName(this.wsdl.getTargetNamespace(), ports[i].getName()));
            ++i;
        }
        return portNames.iterator();
    }

    public Call createCall() throws ServiceException {
        return new CallImpl(this);
    }

    public Call createCall(QName portName) throws ServiceException {
        return new CallImpl(this);
    }

    public Call createCall(QName portName, QName operationName) throws ServiceException {
        CallImpl call = new CallImpl(this);
        call.setOperationName(operationName);
        return call;
    }

    public Call createCall(QName portName, String operationName) throws ServiceException {
        CallImpl call = new CallImpl(this);
        call.setOperationName(new QName(operationName));
        return call;
    }

    public Call[] getCalls(QName portName) throws ServiceException {
        return null;
    }

    public HandlerRegistry getHandlerRegistry() {
        throw new UnsupportedOperationException();
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        throw new UnsupportedOperationException();
    }

    synchronized IReference getReference() throws ServiceException {
        if (this.reference != null) {
            return this.reference;
        }
        String path = this.wsdlDocumentLocation.toString();
        Class[] interfaces = null;
        Context context = new Context();
        try {
            this.reference = Registry.getReference(path, interfaces, context);
            return this.reference;
        }
        catch (RegistryException exception) {
            throw new ServiceException((Throwable)exception);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

