/*
 * Decompiled with CFR 0.152.
 */
package electric.jaxrpc;

import electric.jaxrpc.ServiceImpl;
import electric.soap.java.reference.JavaToSOAP;
import electric.soap.references.ISOAPReference;
import electric.soap.references.SOAPReferenceFactories;
import electric.soap.rpc.In;
import electric.soap.rpc.InOut;
import electric.soap.rpc.Out;
import electric.soap.rpc.Parameter;
import electric.soap.rpc.Return;
import electric.soap.wsdl.DocLitSOAPWriter;
import electric.soap.wsdl.ISOAPWriter;
import electric.soap.wsdl.RPCSOAPWriter;
import electric.soap.wsdl.SOAPMessageDecl;
import electric.soap.wsdl.SOAPOperation;
import electric.util.Context;
import electric.util.Value;
import electric.util.XURL;
import electric.util.array.ArrayUtil;
import electric.util.product.Product;
import electric.util.reflect.Reflect;
import electric.wsdl.Operations;
import electric.xml.io.Namespaces;
import electric.xml.io.Type;
import electric.xml.io.schema.SchemaElement;
import electric.xml.io.schema.SchemaException;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ParameterMode;

public final class CallImpl
implements Call {
    private ServiceImpl service;
    private QName portTypeName;
    private Namespaces namespaces;
    private SOAPOperation operation;
    private Context proxyContext = new Context();
    private Object[] args;
    private XURL endpoint;
    private boolean wasRPC = true;

    public CallImpl(ServiceImpl service) {
        this.service = service;
    }

    public Object getProperty(String name) {
        return this.proxyContext.getProperty(this.getTranslatedName(name));
    }

    public Iterator getPropertyNames() {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration enumeration = this.proxyContext.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            names.add(this.getTranslatedName((String)enumeration.nextElement()));
        }
        return names.iterator();
    }

    public void removeProperty(String name) {
        this.proxyContext.removeProperty(this.getTranslatedName(name));
    }

    public void setProperty(String name, Object value) {
        this.proxyContext.setProperty(this.getTranslatedName(name), value);
    }

    private String getTranslatedName(String name) throws JAXRPCException {
        if (name.equals("javax.xml.rpc.security.auth.username")) {
            return "authUser";
        }
        if (name.equals("javax.xml.rpc.security.auth.password")) {
            return "authPassword";
        }
        if (name.equals("javax.xml.rpc.session.maintain")) {
            return "javax.xml.rpc.session.maintain";
        }
        if (name.equals("javax.xml.rpc.soap.operation.style")) {
            return "javax.xml.rpc.soap.operation.style";
        }
        if (name.equals("javax.xml.rpc.soap.http.soapaction.use")) {
            return "javax.xml.rpc.soap.http.soapaction.use";
        }
        if (name.equals("javax.xml.rpc.soap.http.soapaction.uri")) {
            return "javax.xml.rpc.soap.http.soapaction.uri";
        }
        if (name.equals("javax.xml.rpc.encodingstyle.namespace.uri")) {
            return "javax.xml.rpc.encodingstyle.namespace.uri";
        }
        return name;
    }

    public QName getPortTypeName() {
        return this.portTypeName;
    }

    public void setPortTypeName(QName portTypeName) {
        this.portTypeName = portTypeName;
    }

    public String getTargetEndpointAddress() {
        return this.endpoint.toString();
    }

    public void setTargetEndpointAddress(String address) {
        try {
            this.endpoint = new XURL(address);
        }
        catch (MalformedURLException exception) {
            throw new IllegalArgumentException(exception.toString());
        }
    }

    public QName getOperationName() {
        return new QName(this.operation.getInput().namespace, this.operation.getWriter().getRequestName());
    }

    public void setOperationName(QName operationName) {
        this.initOperation();
        this.operation.setInput(new SOAPMessageDecl(operationName.getNamespaceURI(), false));
        this.operation.setOutput(new SOAPMessageDecl(operationName.getNamespaceURI(), false));
        this.operation.getWriter().setRequestName(operationName.getLocalPart());
    }

    public boolean isParameterAndReturnSpecRequired(QName operationName) {
        return this.service.getWSDLDocumentLocation() == null;
    }

    public void addParameter(String paramName, QName xmlType, ParameterMode parameterMode) {
        this.initOperation();
        Type type = this.getType(xmlType);
        SchemaElement schemaElement = new SchemaElement(paramName, type, false);
        schemaElement.setBare(false);
        schemaElement.setDisableTypeOmission(true);
        if (parameterMode == ParameterMode.IN) {
            this.operation.setInArgCount(this.operation.getInArgCount() + 1);
            this.addParameter(new In(schemaElement, this.operation.getInArgCount()));
        } else if (parameterMode == ParameterMode.OUT) {
            this.operation.setOutArgCount(this.operation.getOutArgCount() + 1);
            this.addParameter(new Out(schemaElement));
        } else {
            this.operation.setInArgCount(this.operation.getInArgCount() + 1);
            this.operation.setOutArgCount(this.operation.getOutArgCount() + 1);
            this.addParameter(new InOut(schemaElement, this.operation.getInArgCount()));
        }
    }

    private void addParameter(Parameter parameter) {
        this.operation.parameters = (Parameter[])ArrayUtil.addElement(this.operation.parameters, parameter);
    }

    public void addParameter(String paramName, QName xmlType, Class javaType, ParameterMode parameterMode) {
        throw new UnsupportedOperationException();
    }

    public QName getParameterTypeByName(String paramName) {
        return null;
    }

    public void removeAllParameters() {
        this.operation.removeParameters();
    }

    public QName getReturnType() {
        try {
            Type type = this.operation.getReturnValue().getType();
            return new QName(type.getNamespace(), type.getName());
        }
        catch (SchemaException exception) {
            return null;
        }
    }

    public void setReturnType(QName xmlType) {
        this.initOperation();
        Type type = this.getType(xmlType);
        this.operation.getWriter().setResponseName("Result");
        SchemaElement schemaElement = new SchemaElement(this.operation.getWriter().getResponseName(), type, false);
        schemaElement.setBare(false);
        schemaElement.setDisableTypeOmission(true);
        this.operation.setReturnValue(new Return(schemaElement));
    }

    public void setReturnType(QName xmlType, Class javaType) {
        throw new UnsupportedOperationException();
    }

    public Object invoke(Object[] inputParams) throws RemoteException {
        return this.invoke(null, inputParams);
    }

    public Object invoke(QName operationName, Object[] inputParams) throws RemoteException {
        if (this.service.getWSDLDocumentLocation() != null) {
            return this.invokeWithWSDL(operationName, inputParams);
        }
        return this.invokeWithoutWSDL(operationName, inputParams);
    }

    private Object invokeWithWSDL(QName operationName, Object[] inputParams) throws RemoteException {
        JavaToSOAP soapReference = null;
        try {
            soapReference = (JavaToSOAP)this.service.getReference();
        }
        catch (Exception exception) {
            throw new JAXRPCException((Throwable)exception);
        }
        String method = operationName.getLocalPart();
        Class[] inArgClasses = Reflect.getClasses(inputParams);
        try {
            Operations operations = soapReference.getOperations();
            this.operation = (SOAPOperation)operations.getOperation(method, inArgClasses, false);
            Parameter[] parameters = this.operation.parameters;
            this.args = new Object[parameters.length];
            int i = 0;
            while (i < parameters.length) {
                this.args[i] = parameters[i].valueOf(inputParams);
                ++i;
            }
            Value value = soapReference.invoke(this.operation, this.args);
            return value.getObject();
        }
        catch (RemoteException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new RemoteException(throwable.toString(), throwable);
        }
    }

    private Object invokeWithoutWSDL(QName operationName, Object[] inputParams) throws RemoteException {
        if (operationName != null) {
            this.setOperationName(operationName);
        }
        try {
            if (Boolean.TRUE.equals(this.proxyContext.getProperty("javax.xml.rpc.soap.http.soapaction.use"))) {
                this.operation.setSoapAction(this.proxyContext.getStringProperty("javax.xml.rpc.soap.http.soapaction.uri", "\"\""));
            }
            this.resetOperation(!"document".equals(this.proxyContext.getProperty("javax.xml.rpc.soap.operation.style")));
            Parameter[] parameters = this.operation.parameters;
            this.args = new Object[parameters.length];
            int i = 0;
            while (i < parameters.length) {
                this.args[i] = parameters[i].valueOf(inputParams);
                ++i;
            }
            ISOAPReference soapReference = SOAPReferenceFactories.newSOAPReference(this.endpoint, null, this.proxyContext);
            JavaToSOAP javaToSoap = new JavaToSOAP(this.endpoint, soapReference, this.proxyContext);
            Value value = javaToSoap.invoke(this.operation, this.args);
            return value.getObject();
        }
        catch (RemoteException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new RemoteException(throwable.toString(), throwable);
        }
    }

    public void invokeOneWay(Object[] inputParams) {
    }

    public Map getOutputParams() {
        HashMap<QName, Object> map = new HashMap<QName, Object>();
        Parameter[] parameters = this.operation.parameters;
        int i = 0;
        while (i < parameters.length) {
            if (parameters[i] instanceof Out) {
                QName name = new QName(parameters[i].getNamespace(), parameters[i].getName());
                map.put(name, parameters[i].getRawObject(this.args[i]));
            }
            ++i;
        }
        return map;
    }

    public List getOutputValues() {
        ArrayList<Object> list = new ArrayList<Object>();
        Parameter[] parameters = this.operation.parameters;
        int i = 0;
        while (i < parameters.length) {
            if (parameters[i] instanceof Out) {
                list.add(parameters[i].getRawObject(this.args[i]));
            }
            ++i;
        }
        return list;
    }

    private synchronized void initOperation() {
        if (this.operation != null) {
            return;
        }
        this.operation = new SOAPOperation();
        this.operation.setPolymorphic(true);
        this.operation.parameters = new Parameter[0];
        this.operation.setNamespaces(this.getNamespaces());
        RPCSOAPWriter writer = new RPCSOAPWriter();
        writer.setSOAPOperation(this.operation);
        this.operation.setWriter(writer);
    }

    private synchronized Namespaces getNamespaces() {
        if (this.namespaces != null) {
            return this.namespaces;
        }
        this.namespaces = new Namespaces("http://www.w3.org/2001/XMLSchema");
        return this.namespaces;
    }

    private Type getType(QName xmlType) throws JAXRPCException {
        try {
            return this.getNamespaces().getTypeWithQName(xmlType.getNamespaceURI(), xmlType.getLocalPart());
        }
        catch (Exception exception) {
            throw new JAXRPCException((Throwable)exception);
        }
    }

    private void resetOperation(boolean rpc) throws SchemaException {
        if (rpc == this.wasRPC) {
            return;
        }
        this.wasRPC = rpc;
        this.operation.removeParameters();
        ISOAPWriter oldWriter = this.operation.getWriter();
        ISOAPWriter newWriter = null;
        newWriter = rpc ? new RPCSOAPWriter(this.operation) : new DocLitSOAPWriter(this.operation);
        this.operation.setWriter(newWriter);
        newWriter.setRequestName(oldWriter.getRequestName());
        newWriter.setResponseName(oldWriter.getResponseName());
        this.operation.setParameterFlags();
    }

    static {
        Product.startup();
    }
}

