/*
 * Decompiled with CFR 0.152.
 */
package electric.http.cookies;

import electric.http.cookies.ClientCookie;
import electric.http.cookies.Cookie0;
import electric.http.cookies.CookieHolder;
import electric.http.cookies.CookieReaper;
import electric.http.cookies.ICookieConstants;
import electric.http.cookies.ICookieListener;
import electric.util.Context;
import electric.util.array.ArrayUtil;
import electric.util.http.IHTTPConstants;
import electric.util.thread.Tasks;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ClientCookies
implements IHTTPConstants,
ICookieConstants {
    private static final Hashtable contextToCookieHolders = new Hashtable();

    private static void initCookieReaper() {
        CookieReaper reaper = new CookieReaper();
        Tasks.getShared().runAfter(reaper, 60000L, "cookie reaper", 60000L, false);
    }

    static synchronized void reap() {
        if (contextToCookieHolders.isEmpty()) {
            return;
        }
        Vector<Context> expiredContexts = new Vector<Context>();
        Enumeration contexts = contextToCookieHolders.keys();
        while (contexts.hasMoreElements()) {
            Vector<CookieHolder> expiredCookies = new Vector<CookieHolder>();
            Context context = (Context)contexts.nextElement();
            ICookieListener cookieListener = (ICookieListener)context.getProperty("cookieListener");
            CookieHolder[] holders = (CookieHolder[])contextToCookieHolders.get(context);
            int i = 0;
            while (i < holders.length) {
                CookieHolder holder = holders[i];
                if (holder.expired()) {
                    if (cookieListener != null) {
                        cookieListener.cookieExpired(holder.getCookie());
                    }
                    expiredCookies.addElement(holder);
                }
                ++i;
            }
            if (expiredCookies.size() == holders.length) {
                expiredContexts.addElement(context);
                continue;
            }
            int i2 = expiredCookies.size() - 1;
            while (i2 >= 0) {
                holders = (CookieHolder[])ArrayUtil.removeElement(holders, expiredCookies.elementAt(i2));
                --i2;
            }
        }
        int i = expiredContexts.size() - 1;
        while (i >= 0) {
            contextToCookieHolders.remove(expiredContexts.elementAt(i));
            --i;
        }
    }

    public static synchronized void addCookie(Context context, ClientCookie cookie) {
        CookieHolder holder;
        CookieHolder[] holders = (CookieHolder[])contextToCookieHolders.get(context);
        if (cookie.getMaxAge() == 0) {
            if (holders == null) {
                return;
            }
            holder = ClientCookies.matchAndUpdateCookie(holders, cookie);
            if (holder != null) {
                ArrayUtil.removeElement(holders, holder);
                return;
            }
        }
        holder = new CookieHolder(cookie);
        if (holders == null) {
            contextToCookieHolders.put(context, new CookieHolder[]{holder});
        } else if (ClientCookies.matchAndUpdateCookie(holders, cookie) == null) {
            contextToCookieHolders.put(context, ArrayUtil.addElement(holders, holder));
        }
    }

    public static CookieHolder[] getCookieHolders(Context context) {
        return (CookieHolder[])contextToCookieHolders.get(context);
    }

    public static void removeCookieHolders(Context context) {
        contextToCookieHolders.remove(context);
    }

    private static CookieHolder matchAndUpdateCookie(CookieHolder[] cookies, ClientCookie cookie) {
        int i = 0;
        while (i < cookies.length) {
            CookieHolder holder = cookies[i];
            if (holder.equivalent(cookie)) {
                holder.getCookie().setValue(cookie.getValue());
                return holder;
            }
            ++i;
        }
        return null;
    }

    public static ClientCookie[] parseSetCookies0(String setCookieHeader, String requestURI) {
        ClientCookie[] cookies = new ClientCookie[]{};
        StringTokenizer tokenizer = new StringTokenizer(setCookieHeader, "=", true);
        String name = tokenizer.nextToken().trim();
        tokenizer.nextToken();
        String value = tokenizer.nextToken(";,").trim();
        if (tokenizer.hasMoreTokens()) {
            tokenizer.nextToken();
        }
        ClientCookie cookie = new ClientCookie(name, value);
        Cookie0.parse(tokenizer, cookie, requestURI);
        cookies = (ClientCookie[])ArrayUtil.addElement(cookies, cookie);
        return cookies;
    }

    static {
        ClientCookies.initCookieReaper();
    }
}

