/*
 * Decompiled with CFR 0.152.
 */
package electric.http.cookies;

import electric.http.cookies.ICookieConstants;

public class ClientCookie
implements Cloneable,
ICookieConstants {
    private String name;
    private String value;
    private String comment;
    private String domain;
    private int maxAge = -1;
    private String path;
    private boolean secure;
    private int version = 0;

    public ClientCookie(String name, String value) {
        if (!this.isToken(name) || name.equalsIgnoreCase("comment") || name.equalsIgnoreCase("discard") || name.equalsIgnoreCase("domain") || name.equalsIgnoreCase("expires") || name.equalsIgnoreCase("max-age") || name.equalsIgnoreCase("path") || name.equalsIgnoreCase("secure") || name.equalsIgnoreCase("version")) {
            throw new IllegalArgumentException("cookie name is a token");
        }
        this.name = name;
        this.value = value;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public void setDomain(String domain) {
        this.domain = domain.toLowerCase();
    }

    public String getDomain() {
        return this.domain;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    private boolean isToken(String value) {
        int len = value.length();
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            if (c < ' ' || c >= '\u007f' || c == ',' || c == ':') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }
}

