/*
 * Decompiled with CFR 0.152.
 */
package electric.http.authentication.basic;

import electric.http.OutboundHTTPRequest;
import electric.http.authentication.IAuthSession;
import electric.security.credentials.PasswordCredentials;
import electric.util.XURL;
import electric.util.http.AuthHeaderData;
import electric.util.http.IHTTPConstants;
import electric.util.string.Base64;
import java.util.StringTokenizer;

public class BasicAuthSession
implements IAuthSession,
IHTTPConstants {
    private PasswordCredentials credentials;
    private String realmName;

    public PasswordCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(PasswordCredentials credentials) {
        this.credentials = credentials;
    }

    private void addBasicAuthHeader(OutboundHTTPRequest request, PasswordCredentials credentials) {
        String base64 = Base64.toBase64((credentials.user + ":" + credentials.password).getBytes());
        request.setHeader("Authorization", "Basic " + base64);
    }

    public AuthHeaderData parseAuthHeader(String header) {
        AuthHeaderData authData = new AuthHeaderData();
        StringTokenizer tokenizer = new StringTokenizer(header, " =");
        authData.authMethod = tokenizer.nextToken();
        tokenizer.nextToken();
        String realmName = tokenizer.nextToken();
        realmName = realmName.trim();
        authData.realmName = realmName.substring(1, realmName.length() - 1);
        return authData;
    }

    public boolean authenticateRealm(XURL host, OutboundHTTPRequest request, AuthHeaderData data) throws SecurityException {
        if (this.credentials == null) {
            throw new SecurityException("no credentials for realm " + this.realmName);
        }
        this.realmName = data.realmName;
        this.addBasicAuthHeader(request, this.credentials);
        return false;
    }

    public void preAuthenticate(XURL host, OutboundHTTPRequest request) {
        if (this.credentials != null) {
            this.addBasicAuthHeader(request, this.credentials);
        }
    }
}

