/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.std.config;

import electric.glue.IGLUELoggingConstants;
import electric.glue.std.config.IConfigConstants;
import electric.registry.IRegistry;
import electric.registry.Registry;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.product.IConfig;
import electric.util.reflect.Creator;
import electric.xml.Element;
import electric.xml.Elements;

public final class RegistryConfig
implements IConfig,
IConfigConstants,
IGLUELoggingConstants {
    public void config(Element config) {
        Element registriesElement = config.getElement("registries");
        if (registriesElement == null) {
            return;
        }
        Elements registries = registriesElement.getElements("registry");
        while (registries.hasMoreElements()) {
            Element registryElement = registries.next();
            try {
                String registryName = registryElement.getString("name");
                String priority = registryElement.getString("priority");
                IRegistry registry = (IRegistry)Creator.newInstance(registryElement, null);
                if (priority != null) {
                    Registry.addRegistry(registryName, registry, Float.parseFloat(priority));
                    continue;
                }
                Registry.addRegistry(registryName, registry);
            }
            catch (Throwable throwable) {
                if (!Log.isLogging(ILoggingConstants.STARTUP_EVENT)) continue;
                Log.log(ILoggingConstants.STARTUP_EVENT, (Object)("could not materialize registry " + registryElement + "\n" + throwable.toString()));
            }
        }
    }
}

