/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.std.config;

import electric.glue.IGLUELoggingConstants;
import electric.glue.std.config.IConfigConstants;
import electric.soap.local.handlers.service.IOperationLookupFactory;
import electric.soap.local.handlers.service.OperationLookupFactories;
import electric.util.classloader.ClassLoaders;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.product.IConfig;
import electric.xml.Element;
import electric.xml.Elements;

public class OperationLookupConfig
implements IConfig,
IConfigConstants,
IGLUELoggingConstants {
    public void config(Element config) throws Throwable {
        if (!config.hasElement("soapOperationLookupFactories")) {
            return;
        }
        Elements operationLookup = config.getElement("soapOperationLookupFactories").getElements("factory");
        while (operationLookup.hasMoreElements()) {
            String className = operationLookup.next().getTrimTextString();
            try {
                Class factory = ClassLoaders.loadClass(className);
                OperationLookupFactories.addFactory((IOperationLookupFactory)factory.newInstance());
            }
            catch (ClassNotFoundException exception) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) continue;
                Log.log(ILoggingConstants.ERROR_EVENT, "could not load class " + className, exception);
            }
            catch (InstantiationException exception) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) continue;
                Log.log(ILoggingConstants.ERROR_EVENT, "could not materialize IOperationLookupFactory " + className, exception);
            }
            catch (IllegalAccessException exception) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) continue;
                Log.log(ILoggingConstants.ERROR_EVENT, "could not call no arg constructor on " + className, exception);
            }
        }
    }
}

