/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.std.config;

import electric.application.simple.SimpleApplication;
import electric.glue.IGLUELoggingConstants;
import electric.glue.std.config.AttachmentsConfig;
import electric.glue.std.config.ClientSocketsConfig;
import electric.glue.std.config.CommandsConfig;
import electric.glue.std.config.DeploymentConfig;
import electric.glue.std.config.HTTPConfig;
import electric.glue.std.config.HTTPEncodingConfig;
import electric.glue.std.config.HTTPProxyConfig;
import electric.glue.std.config.HoldersConfig;
import electric.glue.std.config.IConfigConstants;
import electric.glue.std.config.MessageFactoriesConfig;
import electric.glue.std.config.MimeTypeConfig;
import electric.glue.std.config.OperationLookupConfig;
import electric.glue.std.config.RealmsConfig;
import electric.glue.std.config.RegistryConfig;
import electric.glue.std.config.SOAPEncodingConfig;
import electric.glue.std.config.SOAPHTTPConfig;
import electric.glue.std.config.SOAPHandlerFactoryConfig;
import electric.glue.std.config.SOAPInterceptorConfig;
import electric.glue.std.config.SOAPReferenceFactoryConfig;
import electric.glue.std.config.SSLConfig;
import electric.glue.std.config.ServerSocketsConfig;
import electric.glue.std.config.ServersConfig;
import electric.glue.std.config.ServicesConfig;
import electric.glue.std.config.SessionConfig;
import electric.glue.std.config.SocketFactoriesConfig;
import electric.glue.std.config.ThreadPoolConfig;
import electric.glue.std.config.UDDIConfig;
import electric.glue.std.config.WSDLConfig;
import electric.util.Context;
import electric.util.classloader.ClassLoaders;
import electric.util.context.ContextUtil;
import electric.util.product.ProductConfig;
import electric.xml.Element;
import electric.xml.config.EXMLPlus;
import java.lang.reflect.Method;

public final class Config
extends ProductConfig
implements IGLUELoggingConstants,
IConfigConstants {
    private static final int ID = 1;
    private static final int MAJOR = 5;
    private static final int MINOR = 0;
    private static final int PATCH = 0;

    public Config() {
        super("Glue Standard", 1, 5, 0, 0);
    }

    public void configure(Element config) throws Throwable {
        new EXMLPlus().configure(config);
        ContextUtil.copySystemProperties(IConfigConstants.STD_SYSTEM_PROPERTIES, Context.application());
        new AttachmentsConfig().config(config);
        new MimeTypeConfig().config(config);
        new HTTPEncodingConfig().config(config);
        new SOAPEncodingConfig().config(config);
        new ThreadPoolConfig().config(config);
        new ClientSocketsConfig().config(config);
        new SocketFactoriesConfig().config(config);
        new MessageFactoriesConfig().config(config);
        new WSDLConfig().config(config);
        new RegistryConfig().config(config);
        new SOAPReferenceFactoryConfig().config(config);
        new SSLConfig().config(config);
        new SOAPInterceptorConfig().config(config);
        new SOAPHTTPConfig().config(config);
        new OperationLookupConfig().config(config);
        new HTTPProxyConfig().config(config);
        new ServicesConfig().config(config);
        new HoldersConfig().config(config);
        new UDDIConfig().config(config);
        new SOAPHandlerFactoryConfig().config(config);
        this.startClientSubSystems();
        new CommandsConfig().config(config);
    }

    public void configureAsServer(Element config, Object application) throws Throwable {
        new ServerSocketsConfig().config(config);
        new SessionConfig().config(config);
        new HTTPConfig().config(config);
        new DeploymentConfig().config(config);
        new RealmsConfig().config(config);
        this.startServerSubSystems();
        if (application == null) {
            new SimpleApplication(config).start();
        } else {
            new ServersConfig().config(config);
        }
    }

    public void executeLicenseConstraints() {
    }

    private void startClientSubSystems() throws Exception {
        this.startSubSystems(IConfigConstants.STD_CLIENT_SUBSYSTEMS);
    }

    private void startServerSubSystems() throws Exception {
        this.startSubSystems(IConfigConstants.STD_SERVER_SUBSYSTEMS);
    }

    private void startSubSystems(String[] subsystems) throws Exception {
        int i = 0;
        while (i < subsystems.length) {
            try {
                Class type = ClassLoaders.loadClass(subsystems[i]);
                Method startupMethod = type.getMethod("startup", null);
                startupMethod.invoke(null, null);
            }
            catch (ClassNotFoundException exception) {
                // empty catch block
            }
            ++i;
        }
    }
}

