/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.pro.console.services;

import electric.console.IConsoleConstants;
import electric.console.services.ConsoleModuleInfo;
import electric.console.services.IConsoleModule;
import electric.console.services.ITreeViewProducer;
import electric.glue.pro.console.services.ILicensingConstants;
import electric.util.license.ILicenseConstants;
import electric.util.license.LicenseInfo;
import electric.util.product.Product;
import electric.util.product.ProductInfo;
import electric.xml.Document;
import electric.xml.Element;

public class Licensing
implements ILicenseConstants,
IConsoleModule,
ITreeViewProducer,
ILicensingConstants,
IConsoleConstants {
    private ProductInfo productInfo = Product.getProductConfig().getProductInfo();
    private String productName = this.productInfo.getName();
    private String version = this.productInfo.getMajorVersion() + "." + this.productInfo.getMinorVersion() + "." + this.productInfo.getPatchVersion();
    private ConsoleModuleInfo moduleInfo;

    public Document getActivationInfo() {
        Document doc = new Document();
        Element root = doc.setRoot("Licensing");
        LicenseInfo licenseInfo = Product.getProductConfig().getProductInfo().getLicenseInfo();
        root.setText("ProductName", this.productName + " " + this.version);
        root.setText("UserId", licenseInfo.getUserId());
        root.setText("ActivationCode", licenseInfo.getActivationCode());
        Object expDate = licenseInfo.getProperty("expirationDate");
        root.setText("ExpDate", expDate == null ? "none" : expDate.toString());
        Integer connLimit = (Integer)licenseInfo.getProperty("connectionLimit");
        root.setText("ConnLimit", connLimit == -1 ? "unlimited" : connLimit + "");
        return doc;
    }

    public Element[] getConsoleTreeViewElement(String sessionID) {
        Element element = new Element("TREE");
        element.addText("Product");
        element.setAttribute("Name", "Product");
        element.setAttribute("Function", "showDetails");
        element.setAttribute("TARGET", "_root");
        element.setAttribute("HeaderText", "Product");
        element.setAttribute("swfURL", this.moduleInfo.getSWFURL());
        element.setAttribute("helpfileURL", this.moduleInfo.getHelpFileURL());
        element.setAttribute("serviceURL", this.moduleInfo.getServiceURL());
        return new Element[]{element};
    }

    public boolean isSessionAware() {
        return false;
    }

    public void setConsoleModuleInfo(ConsoleModuleInfo moduleInfo) {
        this.moduleInfo = moduleInfo;
    }
}

