/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.pro.config;

import electric.glue.IGLUELoggingConstants;
import electric.glue.pro.config.IConfigConstants;
import electric.soap.security.SOAPSecurityException;
import electric.soap.security.signature.WSSSignature;
import electric.soap.security.signature.xml.ElementReference;
import electric.soap.security.util.ConfigUtil;
import electric.soap.security.util.KeyStoreUtil;
import electric.util.product.IConfig;
import electric.xml.Element;
import electric.xml.Elements;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

public class WSSSignatureConfig
implements IConfig,
IGLUELoggingConstants,
IConfigConstants {
    public void config(Element wsSecurityElement) throws SOAPSecurityException {
        Elements signatureSpecs = wsSecurityElement.getElements("signatureTemplate");
        while (signatureSpecs.hasMoreElements()) {
            Element signatureElement = signatureSpecs.next();
            String name = signatureElement.getString("name");
            if (name == null) {
                return;
            }
            WSSSignature signatureSpec = new WSSSignature();
            Elements references = signatureElement.getElements("reference");
            while (references.hasMoreElements()) {
                ElementReference reference = ConfigUtil.createReference(references.next());
                if (reference == null) continue;
                signatureSpec.addReference(reference);
            }
            String keyStoreFile = signatureElement.getString("keyStore");
            if (keyStoreFile == null) continue;
            this.configSignatureKeystore(signatureElement, signatureSpec, keyStoreFile);
            WSSSignature.addSignatureSpec(name, signatureSpec);
        }
    }

    private void configSignatureKeystore(Element signatureElement, WSSSignature signatureSpec, String keyStoreFile) throws SOAPSecurityException {
        String keyPassword;
        String password = signatureElement.getString("keyStorePassword");
        if (password == null) {
            password = "";
        }
        if ((keyPassword = signatureElement.getString("privateKeyPassword")) == null) {
            keyPassword = password;
        }
        String keyStoreType = signatureElement.getString("keyStoreType");
        String keyAlias = signatureElement.getString("alias");
        String certificateAlias = signatureElement.getString("certificateAlias");
        if (certificateAlias == null) {
            certificateAlias = keyAlias;
        }
        try {
            KeyStore keyStore = KeyStoreUtil.loadKeyStoreResource(keyStoreFile, password, keyStoreType);
            Certificate cert = keyStore.getCertificate(certificateAlias);
            signatureSpec.setCertificate((X509Certificate)cert);
            PrivateKey key = (PrivateKey)keyStore.getKey(keyAlias, keyPassword.toCharArray());
            signatureSpec.setPrivateKey(key);
        }
        catch (Exception exception) {
            throw new SOAPSecurityException("problem with signature template", exception);
        }
    }
}

