/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.enterprise.console.services;

import electric.cluster.IClusteredApplication;
import electric.cluster.manager.IClusterManager;
import electric.cluster.server.IApplicationServer;
import electric.console.IConsoleConstants;
import electric.console.services.ConsoleFacade;
import electric.console.services.ConsoleModuleInfo;
import electric.console.services.IConsoleModule;
import electric.console.services.ITreeViewProducer;
import electric.fabric.Fabric;
import electric.fabric.IFabricConstants;
import electric.fabric.services.ServiceInfo;
import electric.fabric.services.ServiceManager;
import electric.fabric.services.ServiceManagerException;
import electric.glue.context.ProxyContext;
import electric.glue.enterprise.console.services.IClusterConstants;
import electric.glue.enterprise.console.services.IClustersConstants;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.util.Context;
import electric.util.string.Strings;
import electric.wsdl.util.SignatureGenerator;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.ParseException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;

public class Cluster
implements IConsoleModule,
ITreeViewProducer,
IFabricConstants,
IClusterConstants,
IClustersConstants,
IConsoleConstants {
    private static String applicationServiceSignature;
    private static String applicationServerSignature;
    private String name;
    private ConsoleModuleInfo moduleInfo;
    private HashMap sessionListeners = new HashMap();
    static /* synthetic */ Class class$electric$cluster$IClusteredApplication;
    static /* synthetic */ Class class$electric$cluster$server$IApplicationServer;
    static /* synthetic */ Class class$electric$cluster$manager$IClusterManager;

    public Cluster() {
        applicationServiceSignature = SignatureGenerator.getSignature(class$electric$cluster$IClusteredApplication == null ? (class$electric$cluster$IClusteredApplication = Cluster.class$("electric.cluster.IClusteredApplication")) : class$electric$cluster$IClusteredApplication);
        applicationServerSignature = SignatureGenerator.getSignature(class$electric$cluster$server$IApplicationServer == null ? (class$electric$cluster$server$IApplicationServer = Cluster.class$("electric.cluster.server.IApplicationServer")) : class$electric$cluster$server$IApplicationServer);
    }

    public Document getClusterOverview() {
        Document document = new Document();
        Element overview = document.setRoot("Overview");
        Element applicationsElement = overview.addElement("Applications");
        ServiceInfo[] appServices = this.getServiceInfoForSignature(applicationServiceSignature);
        HashSet<String> addedApps = new HashSet<String>();
        int i = 0;
        while (i < appServices.length) {
            String appName = appServices[i].getMetadata("appName");
            if (!addedApps.contains(appName)) {
                applicationsElement.addElement("Application").addElement("Name").setText(appName);
                addedApps.add(appName);
            }
            ++i;
        }
        Element nodesElement = overview.addElement("Nodes");
        ServiceInfo[] wssNodes = this.getServiceInfoForSignature(applicationServerSignature);
        int i2 = 0;
        while (i2 < wssNodes.length) {
            nodesElement.addElement("Node").addElement("Name").setText(wssNodes[i2].getHostAndPortXURL().toString());
            ++i2;
        }
        return document;
    }

    private ServiceInfo[] getServiceInfoForSignature(String serviceSignature) {
        try {
            String query = "service.signature=" + serviceSignature;
            query = query + "&service.online=true";
            return Fabric.getServiceManager().findServicesForPath(query);
        }
        catch (ServiceManagerException exception) {
            exception.printStackTrace();
            return new ServiceInfo[0];
        }
    }

    public Document renameCluster(Hashtable args) {
        String currentName = (String)args.get("currentname");
        String newName = (String)args.get("newname");
        Document response = new Document(new Element("RenameStatus"));
        try {
            Document requestDoc = new Document((String)args.get("ruleData"));
        }
        catch (ParseException exception) {
            response.getRoot().addElement("statusCode").setInt(100);
            response.getRoot().addElement("errorMessage").setText(exception.toString());
            return response;
        }
        response.getRoot().addElement("statusCode").setInt(0);
        return response;
    }

    public Document getApplicationName(Hashtable args) {
        String sessionId = (String)args.get("SESSIONID");
        int underscoreLoc = sessionId.indexOf(95);
        if (underscoreLoc != -1) {
            int idLength = sessionId.length();
            String timestamp = sessionId.substring(underscoreLoc + 1, idLength);
        } else {
            System.out.println("no timestamp");
        }
        Document response = new Document(new Element("AppName"));
        String appName = "The App Name";
        if (appName == null) {
            response.getRoot().addElement("statusCode").setInt(100);
            response.getRoot().addElement("errorMessage").setText("The application name does not exist");
            return response;
        }
        response.getRoot().addElement("Name").setText("theAppName");
        response.getRoot().addElement("statusCode").setInt(0);
        return response;
    }

    private Vector getApplications() {
        Vector<ServiceInfo> apps = new Vector<ServiceInfo>();
        try {
            String query = "service.signature=" + applicationServiceSignature + "&" + "service.online" + "=true";
            ServiceManager serviceManager = Fabric.getServiceManager();
            if (serviceManager != null) {
                ServiceInfo[] matches = serviceManager.findServicesForPath(query);
                apps.addAll(Arrays.asList(matches));
            }
        }
        catch (ServiceManagerException exception) {
            exception.printStackTrace();
        }
        return apps;
    }

    private Element addApplication(String name) {
        Element element = new Element("TREE");
        this.setAttributes(element, name, "Application");
        Element serviceElement = new Element("TREE");
        this.setAttributes(serviceElement, "Services", "ClusterServices");
        serviceElement.setAttribute("ModuleFunction", "showOverview");
        serviceElement.setAttribute("ApplicationName", name);
        this.setServices(serviceElement, name);
        Element servletElement = new Element("TREE");
        this.setAttributes(servletElement, "Servlets", "ClusterServlets");
        servletElement.setAttribute("ApplicationName", name);
        element.addElement(serviceElement);
        element.addElement(servletElement);
        return element;
    }

    public Document pauseApplication(Hashtable args) {
        String appName = (String)args.get("applicationname");
        Document response = new Document(new Element("ApplicationPause"));
        response.getRoot().addElement("statusCode").setInt(100);
        return response;
    }

    public Document playApplication(Hashtable args) {
        String appName = (String)args.get("applicationname");
        Document response = new Document(new Element("ApplicationPlay"));
        response.getRoot().addElement("statusCode").setInt(100);
        return response;
    }

    public Document removeApplication(Hashtable args) {
        Document response = new Document(new Element("RemoveApplication"));
        String appName = (String)args.get("appName");
        try {
            IClusterManager clusterManager = this.getClusterManager();
            clusterManager.removeApplication(appName);
            response.getRoot().addElement("statusCode").setInt(0);
        }
        catch (RegistryException exception) {
            response.getRoot().addElement("statusCode").setInt(100);
            response.getRoot().addElement("errorMessage").setText("unable to locate cluster manager");
        }
        catch (Exception exception) {
            response.getRoot().addElement("statusCode").setInt(100);
            response.getRoot().addElement("errorMessage").setText("error while removing application " + appName + ". " + exception.toString());
        }
        return response;
    }

    public Document removeNode(Hashtable args) {
        Document response = new Document(new Element("RemoveNode"));
        String nodeName = (String)args.get("nodeName");
        String action = (String)args.get("action");
        response.getRoot().addElement("statusCode").setInt(100);
        return response;
    }

    private TreeSet setServices(Element element, String applicationName) {
        Element registryNode = element.addElement("Registry");
        this.setAttributes(registryNode, "Registry", "ClusterServices");
        registryNode.setAttribute("ModuleFunction", "showFolders");
        HashMap<String, Element> folders = new HashMap<String, Element>();
        folders.put("", registryNode);
        TreeSet services = Cluster.getServicesTree(applicationName);
        Iterator iterator = services.iterator();
        while (iterator.hasNext()) {
            String servicePath = ((String)iterator.next()).replace('\\', '/');
            String endpoint = Strings.getEndpoint(servicePath);
            String urn = Strings.getURN(servicePath);
            Element folder = this.getFolderElement(folders, endpoint);
            Element serviceNode = folder.addElement(urn);
            this.setAttributes(serviceNode, urn, "ClusterServices");
            serviceNode.setAttribute("customIcon", "ftree_icon_ws");
            serviceNode.setAttribute("ModuleFunction", "showService");
        }
        return services;
    }

    private static TreeSet getServicesTree(String appName) {
        ProxyContext context = new ProxyContext();
        context.setProperty("service.appName", appName);
        TreeSet<String> services = new TreeSet<String>();
        try {
            IClusteredApplication application = (IClusteredApplication)Registry.bind(class$electric$cluster$IClusteredApplication == null ? (class$electric$cluster$IClusteredApplication = Cluster.class$("electric.cluster.IClusteredApplication")) : class$electric$cluster$IClusteredApplication, (Context)context);
            String[] endpoints = application.getServicePaths();
            services.addAll(Arrays.asList(endpoints));
        }
        catch (RegistryException exception) {}
        return services;
    }

    public Element[] getConsoleTreeViewElement(String sessionID) {
        if (!this.sessionListeners.containsKey(sessionID)) {
            Vector apps = this.getApplications();
            Element element = new Element("TREE");
            element.addText("Cluster");
            element.setAttribute("Name", "Cluster");
            element.setAttribute("Function", "showDetails");
            element.setAttribute("TARGET", "_root");
            element.setAttribute("swfURL", this.moduleInfo.getSWFURL());
            element.setAttribute("helpfileURL", this.moduleInfo.getHelpFileURL());
            element.setAttribute("serviceURL", this.moduleInfo.getServiceURL());
            this.addCluster(element, apps);
            if (element.getElements().size() == 0) {
                return null;
            }
            this.sessionListeners.put(sessionID, apps);
            Elements appElements = element.getElements();
            Element[] treeViewElements = new Element[appElements.size()];
            int i = 0;
            while (appElements.hasMoreElements()) {
                treeViewElements[i] = appElements.next();
                ++i;
            }
            return treeViewElements;
        }
        return null;
    }

    private void addCluster(Element clusterElement, Vector clusterApps) {
        String appName;
        HashMap<String, Integer> appCounter = new HashMap<String, Integer>();
        HashMap<String, Element> appsMap = new HashMap<String, Element>();
        int maxCounter = 0;
        Enumeration enumeration = clusterApps.elements();
        while (enumeration.hasMoreElements()) {
            ServiceInfo applicationServiceInfo = (ServiceInfo)enumeration.nextElement();
            appName = applicationServiceInfo.getMetadata("appName");
            if (appCounter.containsKey(appName)) {
                int counter = (Integer)appCounter.get(appName) + 1;
                maxCounter = Math.max(counter, maxCounter);
                appCounter.put(appName, new Integer(counter));
                continue;
            }
            appCounter.put(appName, new Integer(1));
            Element appElement = this.addApplication(appName);
            clusterElement.addElement(appElement);
            appsMap.put(appName, appElement);
        }
        Iterator iterator = appCounter.keySet().iterator();
        while (iterator.hasNext()) {
            appName = (String)iterator.next();
            int appCount = (Integer)appCounter.get(appName);
            if (appCount >= maxCounter) continue;
            clusterElement.removeChild((Element)appsMap.get(appName));
        }
    }

    private void setAttributes(Element element, String name, String consoleModuleName) {
        ConsoleModuleInfo moduleInfo = ConsoleFacade.getConsoleModuleInfo(consoleModuleName);
        element.setAttribute("Name", name);
        element.setAttribute("Function", "showDetails");
        element.setAttribute("TARGET", "_root");
        element.setAttribute("swfURL", moduleInfo.getSWFURL());
        element.setAttribute("helpfileURL", moduleInfo.getHelpFileURL());
        element.setAttribute("serviceURL", moduleInfo.getServiceURL());
    }

    private Element getFolderElement(HashMap folders, String folderPath) {
        Element folder = (Element)folders.get(folderPath);
        if (folder == null) {
            String folderName = Strings.getURN(folderPath);
            folder = new Element(folderName);
            this.setAttributes(folder, folderName, "ClusterServices");
            folder.setAttribute("ModuleFunction", "showFolders");
            folders.put(folderPath, folder);
            String folderParent = Strings.getEndpoint(folderPath);
            Element parentElement = this.getFolderElement(folders, folderParent);
            parentElement.addElement(folder);
        }
        return folder;
    }

    public boolean isSessionAware() {
        return true;
    }

    public void setConsoleModuleInfo(ConsoleModuleInfo moduleInfo) {
        this.moduleInfo = moduleInfo;
    }

    public ConsoleModuleInfo getModuleInfo() {
        return this.moduleInfo;
    }

    private IClusterManager getClusterManager() throws RegistryException {
        return (IClusterManager)Registry.bind(class$electric$cluster$manager$IClusterManager == null ? (class$electric$cluster$manager$IClusterManager = Cluster.class$("electric.cluster.manager.IClusterManager")) : class$electric$cluster$manager$IClusterManager);
    }

    private IApplicationServer getWSServer(String nodeName) throws RegistryException {
        return (IApplicationServer)Registry.bind(Strings.splice(nodeName, "system/enterprise.wsdl"), class$electric$cluster$server$IApplicationServer == null ? (class$electric$cluster$server$IApplicationServer = Cluster.class$("electric.cluster.server.IApplicationServer")) : class$electric$cluster$server$IApplicationServer);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

