/*
 * Decompiled with CFR 0.152.
 */
package electric.getpost.wsdl;

import electric.getpost.wsdl.HTTPBinding;
import electric.util.XURL;
import electric.wsdl.Port;
import electric.wsdl.Service;
import electric.wsdl.WSDLException;
import electric.xml.Element;
import electric.xml.io.schema.SchemaException;

public final class HTTPPort
extends Port {
    public HTTPPort(Service service, Element port) throws WSDLException, SchemaException {
        super(service, port);
        Element address = port.getElement("address");
        if (address == null) {
            throw new WSDLException("HTTP <port> is missing address element");
        }
        String location = address.getAttributeValue("location");
        if (location == null) {
            throw new WSDLException("HTTP <port> is missing location attribute");
        }
        try {
            this.setEndpoint(location);
        }
        catch (Exception exception) {
            throw new WSDLException(exception.toString());
        }
    }

    public HTTPPort(Service service, HTTPBinding binding, String name, XURL endpoint) {
        super(service, binding, name + (binding.isGet() ? "-HttpGet" : "-HttpPost"), endpoint);
    }

    public Element writeWSDL(Element service) {
        Element port = super.writeWSDL(service);
        Element httpAddress = port.addElement("http", "address");
        httpAddress.setAttribute("location", this.endpoint.toString());
        return port;
    }
}

