/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.services.broker.locators.subnet;

import electric.fabric.Fabric;
import electric.fabric.IFabricConstants;
import electric.fabric.services.broker.BrokerInfo;
import electric.fabric.services.broker.IBroker;
import electric.fabric.services.broker.IBrokerLocator;
import electric.fabric.services.broker.IBrokersListener;
import electric.glue.IGLUELoggingConstants;
import electric.net.broadcast.Broadcaster;
import electric.net.broadcast.Broadcasters;
import electric.net.broadcast.IBroadcastListener;
import electric.registry.Registry;
import electric.util.Context;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.time.TimeUtil;
import electric.xml.Document;
import electric.xml.Element;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Vector;

public class SubnetLocator
implements IBrokerLocator,
IBroadcastListener,
Runnable,
IGLUELoggingConstants,
IFabricConstants,
IBrokersListener {
    private static final String BROKER = "broker";
    private static final String FIND_BROKER = "findBroker";
    private static final String URL = "url";
    private int port;
    private int pingCycle;
    private int maxWaitTime;
    private Broadcaster broadcaster;
    private Vector brokerURLs = new Vector();
    private Document document;
    private byte[] bytes;
    private boolean running;
    private IBrokerLocator locator;
    static /* synthetic */ Class class$electric$fabric$services$broker$IBroker;

    public SubnetLocator(int port, int maxWaitTime, int pingCycle, String locatorName) throws IOException {
        String portString = Context.getSystemProperty("fabric.port");
        if (portString != null) {
            port = Integer.parseInt(portString);
        }
        this.port = port;
        this.maxWaitTime = maxWaitTime * 1000;
        this.pingCycle = pingCycle * 1000;
        this.locator = Fabric.getServiceManager().getBrokerLocator(locatorName);
        this.broadcaster = Broadcasters.getBroadcaster(port);
        this.broadcaster.addListener(this);
        Log.log(ILoggingConstants.STARTUP_EVENT, (Object)("udp broadcast discovery started on port " + port));
    }

    public String toString() {
        return "SubnetLocator( port=" + this.port + " )";
    }

    public int getPort() {
        return this.port;
    }

    public int getPingCycle() {
        return this.pingCycle;
    }

    public void setPingCycle(int pingCycle) {
        this.pingCycle = pingCycle;
    }

    public BrokerInfo getBrokerInfo() {
        BrokerInfo brokerInfo = this.findBrokerOnSubnet();
        if (brokerInfo != null) {
            return brokerInfo;
        }
        if (Log.isLogging(IFabricConstants.LOCATOR_EVENT)) {
            Log.log(IFabricConstants.LOCATOR_EVENT, (Object)("could not find on subnet, trying locator " + this.locator));
        }
        return this.locator.getBrokerInfo();
    }

    private BrokerInfo findBrokerOnSubnet() {
        this.brokerURLs.clear();
        try {
            byte[] bytes = this.getBytes();
            if (Log.isLogging(IFabricConstants.LOCATOR_EVENT)) {
                Log.log(IFabricConstants.LOCATOR_EVENT, (Object)("send " + this.document));
            }
            this.broadcaster.send(bytes);
        }
        catch (IOException exception) {
            return null;
        }
        long start = TimeUtil.now();
        long timeLeft;
        while ((timeLeft = (long)this.maxWaitTime - (TimeUtil.now() - start)) > 0L) {
            String url = this.getBrokerURL(timeLeft);
            if (url == null) {
                return null;
            }
            try {
                IBroker broker = (IBroker)Registry.bind(url, class$electric$fabric$services$broker$IBroker == null ? (class$electric$fabric$services$broker$IBroker = SubnetLocator.class$("electric.fabric.services.broker.IBroker")) : class$electric$fabric$services$broker$IBroker);
                broker.livenessPing();
                return new BrokerInfo(url, broker);
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
        return null;
    }

    public void received(InetAddress source, int port, byte[] bytes) {
        try {
            String name;
            Document document = new Document(bytes);
            if (Log.isLogging(IFabricConstants.LOCATOR_EVENT)) {
                Log.log(IFabricConstants.LOCATOR_EVENT, (Object)("received " + document));
            }
            if ((name = document.getRoot().getName()).equals(BROKER)) {
                this.receivedBroker(document);
            } else if (name.equals(FIND_BROKER)) {
                this.receivedFindBroker(document);
            }
        }
        catch (Exception exception) {}
    }

    private void receivedBroker(Document document) {
        Element root = document.getRoot();
        String url = root.getString(URL);
        if (url != null) {
            this.addBrokerURL(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBrokerURL(String url) {
        Vector vector = this.brokerURLs;
        synchronized (vector) {
            this.brokerURLs.addElement(url);
            this.brokerURLs.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBrokerURL(long timeLeft) {
        Vector vector = this.brokerURLs;
        synchronized (vector) {
            if (this.brokerURLs.isEmpty()) {
                try {
                    this.brokerURLs.wait(timeLeft);
                }
                catch (InterruptedException exception) {
                    // empty catch block
                }
            }
            if (this.brokerURLs.isEmpty()) {
                return null;
            }
            String url = (String)this.brokerURLs.elementAt(0);
            this.brokerURLs.removeElementAt(0);
            return url;
        }
    }

    private synchronized byte[] getBytes() throws IOException {
        if (this.bytes != null) {
            return this.bytes;
        }
        this.document = new Document();
        this.document.setRoot(FIND_BROKER);
        this.bytes = this.document.getBytes();
        return this.bytes;
    }

    public void addedLocalBroker(IBroker broker) {
        this.running = true;
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
    }

    public void removedLocalBroker(IBroker broker) {
        this.running = false;
    }

    public void run() {
        while (this.running) {
            try {
                this.sendBroker();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Thread.sleep(this.pingCycle);
            }
            catch (InterruptedException exception) {
                // empty catch block
            }
        }
    }

    private void receivedFindBroker(Document document) throws IOException {
        if (Fabric.getServiceManager().getBrokerInfo() != null) {
            this.sendBroker();
        }
    }

    private void sendBroker() throws IOException {
        Document document = new Document();
        Element root = document.setRoot(BROKER);
        root.setString(URL, Fabric.getServiceManager().getBrokerInfo().getURL());
        if (Log.isLogging(IFabricConstants.LOCATOR_EVENT)) {
            Log.log(IFabricConstants.LOCATOR_EVENT, (Object)("send " + document));
        }
        byte[] bytes = document.getBytes();
        this.broadcaster.send(bytes);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

