/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.services;

import electric.fabric.IFabricConstants;
import electric.glue.IGLUELoggingConstants;
import electric.soap.references.ISOAPReference;
import electric.soap.references.SOAPReferenceFactories;
import electric.util.Context;
import electric.util.XURL;
import electric.util.http.HTTPUtil;
import electric.util.time.TimeUtil;
import electric.wsdl.WSDL;
import electric.wsdl.loader.WSDLLoader;
import electric.wsdl.util.SignatureGenerator;
import electric.xml.Element;
import electric.xml.Elements;
import java.io.IOException;

public class ServiceInfo
implements IGLUELoggingConstants,
IFabricConstants {
    private String description;
    private Element metadata;
    private transient WSDL wsdl;
    private transient ISOAPReference soapReference;
    static /* synthetic */ Class class$electric$soap$wsdl$SOAPPort;

    public ServiceInfo() {
    }

    public ServiceInfo(String wsdlURL) throws Exception {
        this(wsdlURL, new Context());
    }

    public ServiceInfo(String wsdlURL, Context context) throws Exception {
        this.setWSDLURL(wsdlURL);
        this.wsdl = WSDLLoader.getWSDL(wsdlURL, context);
        if (this.wsdl.getTModel() == null) {
            this.wsdl.setTModel(SignatureGenerator.getSignature(this.wsdl));
        }
        this.setSignature(this.wsdl.getTModel());
        XURL[] endpoints = this.wsdl.getEndpoints(class$electric$soap$wsdl$SOAPPort == null ? (class$electric$soap$wsdl$SOAPPort = ServiceInfo.class$("electric.soap.wsdl.SOAPPort")) : class$electric$soap$wsdl$SOAPPort);
        if (endpoints.length > 0) {
            this.setEndpoint(endpoints[0].toString());
        }
        this.setDescription(this.getEndpoint());
        this.setOnline(true);
    }

    public ServiceInfo(ServiceInfo serviceInfo) {
        this.description = serviceInfo.description;
        this.metadata = new Element(serviceInfo.metadata);
        this.wsdl = serviceInfo.wsdl;
        this.soapReference = serviceInfo.soapReference;
    }

    public String toString() {
        return "ServiceInfo( description=" + this.description + ", metadata=" + this.metadata + " )";
    }

    public String getWSDLURL() {
        return this.getMetadata("wsdl");
    }

    public XURL getWSDLXURL() {
        try {
            return new XURL(this.getWSDLURL());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized WSDL getWSDL() {
        if (this.wsdl != null) {
            return this.wsdl;
        }
        try {
            this.wsdl = WSDLLoader.getWSDL(this.getWSDLURL());
        }
        catch (Exception exception) {}
        return this.wsdl;
    }

    public void setWSDLURL(String wsdlURL) {
        this.addMetadata("wsdl", wsdlURL);
        this.wsdl = null;
    }

    public void setEndpoint(String endpoint) {
        this.addMetadata("endpoint", endpoint);
    }

    public String getEndpoint() {
        return this.getMetadata("endpoint");
    }

    public XURL getEndpointXURL() {
        try {
            return new XURL(this.getEndpoint());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public XURL getHostAndPortXURL() {
        try {
            return new XURL(this.getEndpoint()).getHostAndPortXURL();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setOnline(boolean online) {
        this.addMetadata("online", online ? "true" : "false");
        this.addMetadata("since", Long.toString(TimeUtil.now()));
    }

    public boolean isOnline() {
        String online = this.getMetadata("online");
        return online == null || online.equals("true");
    }

    public long getSince() {
        String since = this.getMetadata("since");
        if (since == null) {
            return 0L;
        }
        return Long.parseLong(since);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSignature() {
        return this.getMetadata("signature");
    }

    public void setSignature(String signature) {
        this.addMetadata("signature", signature);
    }

    public synchronized ISOAPReference getSOAPReference() {
        if (this.soapReference != null) {
            return this.soapReference;
        }
        Context context = new Context();
        this.soapReference = SOAPReferenceFactories.newSOAPReference(this.getEndpointXURL(), null, context);
        return this.soapReference;
    }

    public synchronized void addMetadata(String key, String value) {
        if (this.metadata == null) {
            this.metadata = new Element("values");
        }
        this.metadata.setString(key, value);
    }

    public synchronized void addMetadata(String key) {
        if (this.metadata == null) {
            this.metadata = new Element("values");
        }
        this.metadata.addElement(key);
    }

    public synchronized void setMetadata(Element metadata) {
        this.metadata = metadata;
    }

    public synchronized String getMetadata(String key) {
        if (this.metadata == null) {
            return null;
        }
        return this.metadata.getString(key);
    }

    public Element getMetadata() {
        return this.metadata;
    }

    public synchronized void removeMetadata(String key) {
        if (this.metadata == null) {
            return;
        }
        this.metadata.removeElement(key);
    }

    public synchronized void setMetadata(String metadataString) throws IOException {
        if (metadataString == null || metadataString.length() == 0) {
            this.metadata = null;
        } else {
            String[][] properties = HTTPUtil.getParametersAsArray(metadataString);
            this.metadata = new Element("values");
            int i = 0;
            while (i < properties.length) {
                this.metadata.setString(properties[i][0], properties[i][1]);
                ++i;
            }
        }
    }

    public synchronized String getMetadataAsString() {
        if (this.metadata == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        Elements children = this.metadata.getElements();
        while (children.hasMoreElements()) {
            if (buffer.length() > 0) {
                buffer.append("&");
            }
            Element child = children.next();
            buffer.append(child.getName());
            if (!child.hasText() || child.getText().getString().length() <= 0) continue;
            buffer.append("=" + child.getText());
        }
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

