/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.rules.processors.transform;

import electric.fabric.rules.processors.Processor;
import electric.fabric.rules.processors.transform.XSLTTransform;
import electric.soap.SOAPMessage;
import electric.util.Context;
import electric.xml.Document;
import java.rmi.RemoteException;

public class Transform
extends Processor {
    private XSLTTransform requestTransform;
    private XSLTTransform responseTransform;

    public Transform() {
    }

    public Transform(Document transform) {
        this(new XSLTTransform(transform), new XSLTTransform(transform));
    }

    public Transform(Document requestTransform, Document responseTransform) {
        this(new XSLTTransform(requestTransform), new XSLTTransform(responseTransform));
    }

    public Transform(XSLTTransform transform) {
        this(transform, transform);
    }

    public Transform(XSLTTransform requestTransform, XSLTTransform responseTransform) {
        this.requestTransform = requestTransform;
        this.responseTransform = responseTransform;
    }

    public XSLTTransform getRequestTransform() {
        return this.requestTransform;
    }

    public XSLTTransform getResponseTransform() {
        return this.responseTransform;
    }

    public String toString() {
        return "Transform()";
    }

    public Object deepCopy() {
        return this.shallowCopy();
    }

    public Object shallowCopy() {
        return new Transform(this.requestTransform, this.responseTransform);
    }

    public SOAPMessage handle(SOAPMessage request, Context messageContext) throws RemoteException, SecurityException {
        try {
            if (this.requestTransform != null) {
                Document requestDocument = this.requestTransform.transform(request.getDocument());
                request = new SOAPMessage();
                request.setDocument(requestDocument);
            }
            SOAPMessage response = this.nextHandler.handle(request, messageContext);
            if (this.responseTransform != null) {
                Document responseDocument = this.responseTransform.transform(response.getDocument());
                response = new SOAPMessage();
                response.setDocument(responseDocument);
            }
            return response;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

