/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.rules.processors.performance;

import electric.fabric.endpoints.performance.IPerformance;
import electric.fabric.endpoints.performance.PerformanceInfo;
import electric.fabric.rules.processors.Processor;
import electric.soap.SOAPMessage;
import electric.util.Context;
import electric.util.time.TimeUtil;
import java.rmi.RemoteException;
import java.util.Vector;

public class MeasurePerformance
extends Processor
implements IPerformance {
    private transient PerformanceInfo cumulative;
    private transient Vector snapshots;

    public MeasurePerformance() {
        this.cumulative = new PerformanceInfo();
        this.snapshots = new Vector();
    }

    public MeasurePerformance(PerformanceInfo cumulative, Vector snapshots) {
        this.cumulative = cumulative;
        this.snapshots = snapshots;
    }

    public String toString() {
        return "MeasurePerformance()";
    }

    public Object deepCopy() {
        return new MeasurePerformance();
    }

    public Object shallowCopy() {
        return new MeasurePerformance(this.cumulative, this.snapshots);
    }

    public SOAPMessage handle(SOAPMessage request, Context messageContext) throws RemoteException, SecurityException {
        try {
            SOAPMessage response = this.nextHandler.handle(request, messageContext);
            this.addPerformanceData(request, response, messageContext);
            return response;
        }
        catch (RemoteException exception) {
            this.addPerformanceData(request, exception, messageContext);
            throw exception;
        }
        catch (SecurityException exception) {
            this.addPerformanceData(request, exception, messageContext);
            throw exception;
        }
        catch (RuntimeException exception) {
            this.addPerformanceData(request, exception, messageContext);
            throw exception;
        }
    }

    private void addPerformanceData(SOAPMessage request, SOAPMessage response, Context messageContext) {
        this.cumulative.requestResponse(request, response, messageContext);
        this.getSnapshot().requestResponse(request, response, messageContext);
    }

    private void addPerformanceData(SOAPMessage request, Exception exception, Context messageContext) {
        this.cumulative.requestResponse(request, exception, messageContext);
        this.getSnapshot().requestResponse(request, exception, messageContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerformanceInfo getPerformanceInfo(long start, long stop) {
        PerformanceInfo data = new PerformanceInfo();
        Vector vector = this.snapshots;
        synchronized (vector) {
            int i = 0;
            while (i < this.snapshots.size()) {
                PerformanceInfo snapshot = (PerformanceInfo)this.snapshots.elementAt(i);
                if (snapshot.getStart() + 1000L >= start) {
                    if (snapshot.getStart() >= stop) break;
                    long begin = snapshot.getStart() < start ? start : snapshot.getStart();
                    long end = snapshot.getStart() + 1000L > stop ? stop : snapshot.getStart() + 1000L;
                    long period = end - begin;
                    float percentage = (float)period / 1000.0f;
                    data.setRequests(data.getRequests() + (int)((float)snapshot.getRequests() * percentage));
                    data.setResponses(data.getResponses() + (int)((float)snapshot.getRequests() * percentage));
                    data.setExceptions(data.getExceptions() + (int)((float)snapshot.getExceptions() * percentage));
                    data.setTotalBytes(data.getTotalBytes() + (long)((int)((float)snapshot.getTotalBytes() * percentage)));
                }
                ++i;
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PerformanceInfo getSnapshot() {
        Vector vector = this.snapshots;
        synchronized (vector) {
            PerformanceInfo lastData;
            long now = TimeUtil.now();
            if (!this.snapshots.isEmpty() && now < (lastData = (PerformanceInfo)this.snapshots.lastElement()).getStart() + 1000L) {
                return lastData;
            }
            PerformanceInfo newData = new PerformanceInfo();
            newData.setStart(TimeUtil.now());
            this.snapshots.addElement(newData);
            if (this.snapshots.size() > 30) {
                this.snapshots.removeElementAt(0);
            }
            return newData;
        }
    }
}

