/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.rules.processors.monitor;

import electric.fabric.rules.actions.IAction;
import electric.fabric.rules.actions.Performer;
import electric.fabric.rules.conditions.IBinaryCondition;
import electric.fabric.rules.conditions.IUnaryCondition;
import electric.fabric.rules.processors.Processor;
import electric.soap.SOAPMessage;
import electric.util.Context;
import electric.util.thread.Tasks;
import java.rmi.RemoteException;

public class Monitor
extends Processor {
    private IUnaryCondition[] requestConditions;
    private IUnaryCondition[] responseConditions;
    private IBinaryCondition[] requestResponseConditions;
    private IAction[] actions;

    public Monitor() {
    }

    public Monitor(IUnaryCondition[] requestConditions, IUnaryCondition[] responseConditions, IBinaryCondition[] requestResponseConditions, IAction[] actions) {
        this.requestConditions = requestConditions;
        this.responseConditions = responseConditions;
        this.requestResponseConditions = requestResponseConditions;
        this.actions = actions;
    }

    public IUnaryCondition[] getRequestConditions() {
        return this.requestConditions;
    }

    public IUnaryCondition[] getResponseConditions() {
        return this.responseConditions;
    }

    public IBinaryCondition[] getRequestResponseConditions() {
        return this.requestResponseConditions;
    }

    public IAction[] getActions() {
        return this.actions;
    }

    public String toString() {
        return "Monitor()";
    }

    public Object deepCopy() {
        return this.shallowCopy();
    }

    public Object shallowCopy() {
        return new Monitor(this.requestConditions, this.responseConditions, this.requestResponseConditions, this.actions);
    }

    public SOAPMessage handle(SOAPMessage request, Context messageContext) throws RemoteException, SecurityException {
        SOAPMessage response = this.nextHandler.handle(request, messageContext);
        if (this.requestConditions != null) {
            int i = 0;
            while (i < this.requestConditions.length) {
                if (this.requestConditions[i].satisfiedBy(request, messageContext)) {
                    this.performActions(request, response, messageContext);
                    return response;
                }
                ++i;
            }
        }
        if (this.responseConditions != null) {
            int i = 0;
            while (i < this.responseConditions.length) {
                if (this.responseConditions[i].satisfiedBy(response, messageContext)) {
                    this.performActions(request, response, messageContext);
                    return response;
                }
                ++i;
            }
        }
        if (this.requestResponseConditions != null) {
            int i = 0;
            while (i < this.requestResponseConditions.length) {
                if (this.requestResponseConditions[i].satisfiedBy(request, response, messageContext)) {
                    this.performActions(request, response, messageContext);
                    return response;
                }
                ++i;
            }
        }
        return response;
    }

    private void performActions(SOAPMessage request, SOAPMessage response, Context messageContext) {
        Tasks.getShared().run(new Performer(this.actions, request, response, messageContext));
    }
}

