/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.jaxrpc;

import electric.fabric.Fabric;
import electric.fabric.IFabricConstants;
import electric.fabric.services.ServiceManagerException;
import electric.fabric.services.ServicePath;
import electric.glue.context.ProxyContext;
import electric.util.Context;
import electric.util.http.HTTPUtil;
import electric.wsdl.Service;
import electric.wsdl.WSDL;
import electric.wsdl.util.SignatureGenerator;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import javax.xml.namespace.QName;

public class FabricUtil
implements IFabricConstants {
    public static QName pickServiceQName(ServicePath bestService) {
        WSDL wsdl = bestService.getServiceInfo().getWSDL();
        Enumeration services = wsdl.getServices();
        QName serviceQName = null;
        if (services.hasMoreElements()) {
            Service service = (Service)services.nextElement();
            serviceQName = service.getNamespace() == null ? new QName(service.getName()) : new QName(service.getNamespace(), service.getName());
        }
        return serviceQName;
    }

    protected static URL getLocationSpec(URL fabricURL) {
        try {
            if (fabricURL == null) {
                fabricURL = new URL("fabric://?failover");
            } else if (fabricURL.getQuery() == null) {
                fabricURL = new URL(fabricURL.toExternalForm() + "?failover");
            }
        }
        catch (MalformedURLException exception) {
            return null;
        }
        return fabricURL;
    }

    public static ServicePath getBestService(String queryString, Context proxyContext) {
        try {
            ServicePath bestService = Fabric.getServiceManager().selectService(queryString);
            return bestService;
        }
        catch (ServiceManagerException exception) {
            return null;
        }
    }

    public static String addSignature(Class serviceEndpointInterface, String queryString) {
        ProxyContext proxyContext = new ProxyContext();
        String signature = HTTPUtil.getParameter(queryString = FabricUtil.buildProxyContext(proxyContext, queryString), "service.signature");
        if (signature == null && (signature = SignatureGenerator.getSignature(new Class[]{serviceEndpointInterface}, proxyContext)) != null) {
            queryString = queryString == null || queryString.length() == 0 ? "?service.signature=" + signature : queryString + "&service.signature=" + signature;
        }
        return queryString;
    }

    protected static String buildProxyContext(ProxyContext proxyContext, String queryString) {
        String[][] queryParameters = null;
        try {
            queryParameters = HTTPUtil.getParametersAsArray(queryString);
        }
        catch (IOException exception) {
            // empty catch block
        }
        int i = 0;
        while (i < queryParameters.length) {
            String[] parameter = queryParameters[i];
            String name = parameter[0];
            if (name.startsWith("service.")) {
                proxyContext.setProperty(name, parameter[1]);
                queryString = HTTPUtil.removeParameter(queryString, name);
            } else if (name.startsWith("proxy.")) {
                String key = name.substring("proxy.".length());
                proxyContext.setProperty(key, parameter[1]);
                queryString = HTTPUtil.removeParameter(queryString, name);
            }
            ++i;
        }
        return queryString;
    }
}

