/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.jaxrpc;

import electric.fabric.jaxrpc.FabricService;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.ParameterMode;

public class FabricCall
implements Call {
    protected FabricService fabricService;
    protected Call baseCall;
    protected boolean gaiaBinding;

    public FabricCall(FabricService fabricService, Call baseCall) {
        this.fabricService = fabricService;
        this.baseCall = baseCall;
    }

    public boolean isParameterAndReturnSpecRequired(QName operationName) {
        return this.baseCall.isParameterAndReturnSpecRequired(operationName);
    }

    public void addParameter(String paramName, QName xmlType, ParameterMode parameterMode) {
        this.baseCall.addParameter(paramName, xmlType, parameterMode);
    }

    public void addParameter(String paramName, QName xmlType, Class javaType, ParameterMode parameterMode) {
        this.baseCall.addParameter(paramName, xmlType, javaType, parameterMode);
    }

    public QName getParameterTypeByName(String paramName) {
        return this.baseCall.getParameterTypeByName(paramName);
    }

    public void setReturnType(QName xmlType) {
        this.baseCall.setReturnType(xmlType);
    }

    public void setReturnType(QName xmlType, Class javaType) {
        this.baseCall.setReturnType(xmlType, javaType);
    }

    public QName getReturnType() {
        return this.baseCall.getReturnType();
    }

    public void removeAllParameters() {
        this.baseCall.removeAllParameters();
    }

    public QName getOperationName() {
        return this.baseCall.getOperationName();
    }

    public void setOperationName(QName operationName) {
        this.baseCall.setOperationName(operationName);
    }

    public QName getPortTypeName() {
        return this.baseCall.getPortTypeName();
    }

    public void setPortTypeName(QName portType) {
        this.baseCall.setPortTypeName(portType);
    }

    public void setTargetEndpointAddress(String address) {
        System.out.println("FabricCall.setTargetEndpointAddress(" + address + ")");
        if (address != null && !address.startsWith("gaia://")) {
            this.baseCall.setTargetEndpointAddress(address);
            this.gaiaBinding = false;
            return;
        }
        this.gaiaBinding = true;
    }

    public String getTargetEndpointAddress() {
        return this.baseCall.getTargetEndpointAddress();
    }

    public void setProperty(String name, Object value) {
        this.baseCall.setProperty(name, value);
    }

    public Object getProperty(String name) {
        return this.baseCall.getProperty(name);
    }

    public void removeProperty(String name) {
        this.baseCall.removeProperty(name);
    }

    public Iterator getPropertyNames() {
        return this.baseCall.getPropertyNames();
    }

    protected Object lazyInvoke(Object[] inputParams) throws RemoteException {
        return null;
    }

    public Object invoke(Object[] inputParams) throws RemoteException {
        System.out.println("FabricCall.invoke()");
        if (this.gaiaBinding) {
            return this.lazyInvoke(inputParams);
        }
        return this.baseCall.invoke(inputParams);
    }

    public Object invoke(QName operationName, Object[] inputParams) throws RemoteException {
        return this.baseCall.invoke(operationName, inputParams);
    }

    public void invokeOneWay(Object[] params) {
        this.baseCall.invokeOneWay(params);
    }

    public Map getOutputParams() {
        return this.baseCall.getOutputParams();
    }

    public List getOutputValues() {
        return this.baseCall.getOutputValues();
    }
}

