/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.intermediary;

import electric.fabric.Fabric;
import electric.fabric.IFabricConstants;
import electric.fabric.services.ServiceInfo;
import electric.fabric.services.ServicePath;
import electric.registry.RegistryException;
import electric.servlet.util.HTTPServletUtil;
import electric.util.array.ByteArray;
import electric.util.http.HTTPUtil;
import electric.util.http.IHTTPConstants;
import electric.util.io.FastByteArrayOutputStream;
import electric.util.io.Streams;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.string.Strings;
import electric.wsdl.WSDL;
import electric.wsdl.util.WSDLSwizzler;
import electric.xml.Document;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class WSDLHandler
extends HttpServlet
implements IHTTPConstants,
IFabricConstants,
ILoggingConstants {
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String queryString = request.getQueryString();
        if (queryString == null) {
            queryString = (String)request.getAttribute("queryString");
        }
        try {
            String path = "?glue&" + queryString;
            ServicePath servicePath = Fabric.getServiceManager().selectService(path);
            if (servicePath == null) {
                throw new RegistryException("cannot bind to service with path " + path);
            }
            ServiceInfo serviceInfo = servicePath.getServiceInfo();
            WSDL wsdl = serviceInfo.getWSDL();
            String endpoint = this.getEndpoint(path, servicePath);
            if (Log.isLogging(IFabricConstants.INTERMEDIARY_EVENT)) {
                Log.log(IFabricConstants.INTERMEDIARY_EVENT, (Object)("path " + path + " maps to " + endpoint));
            }
            ByteArray byteArray = this.getWSDLByteArray(wsdl, endpoint);
            this.sendWSDL(request, response, byteArray);
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
            }
            this.sendNoReferenceException(response, queryString);
        }
    }

    private String getEndpoint(String path, ServicePath servicePath) {
        String endpoint = null;
        if (HTTPUtil.hasParameter(path, "failover")) {
            endpoint = Fabric.getSOAPHandler().getPath() + path;
        } else {
            endpoint = servicePath.getIntermediary() == null ? servicePath.getServiceInfo().getEndpoint() : servicePath.getIntermediary() + "?glue" + "&" + "service.wsdl" + "=" + servicePath.getServiceInfo().getWSDLURL() + "&" + "session.useCookies";
            if (HTTPUtil.hasParameter(path, "monitor")) {
                endpoint = HTTPUtil.addParameter(endpoint, "monitor");
            }
        }
        return endpoint;
    }

    private ByteArray getWSDLByteArray(WSDL wsdl, String endpoint) throws IOException {
        Document document = wsdl.getDocument();
        endpoint = Strings.replace(endpoint, "&", "&amp;");
        FastByteArrayOutputStream stream = new FastByteArrayOutputStream();
        Writer writer = Streams.getWriter(stream, document.getEncoding());
        WSDLSwizzler swizzler = new WSDLSwizzler(writer, -1, true, endpoint);
        swizzler.write(document);
        swizzler.flush();
        return stream.getByteArray();
    }

    private void sendNoReferenceException(HttpServletResponse response, String queryString) throws IOException {
        response.sendError(404, "cannot find wsdl for " + queryString);
    }

    private void sendWSDL(HttpServletRequest request, HttpServletResponse response, ByteArray byteArray) throws IOException {
        response.setContentType("text/xml");
        response.setStatus(200);
        response.setHeader("Server", IHTTPConstants.SERVER_TYPE);
        HTTPServletUtil.writeContent(request, response, byteArray);
    }
}

