/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.endpoints.performance;

import electric.soap.SOAPMessage;
import electric.util.Context;

public class PerformanceInfo {
    private long start;
    private long stop;
    private int requests;
    private int responses;
    private int exceptions;
    private long totalBytes;

    public String toString() {
        return "PerformanceInfo( start=" + this.start + ", requests=" + this.requests + ", responses=" + this.responses + ", exceptions=" + this.exceptions + ", totalBytes=" + this.totalBytes + " )";
    }

    public int getRequests() {
        return this.requests;
    }

    public void setRequests(int requests) {
        this.requests = requests;
    }

    public int getResponses() {
        return this.responses;
    }

    public void setResponses(int responses) {
        this.responses = responses;
    }

    public int getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(int exceptions) {
        this.exceptions = exceptions;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public long getStop() {
        return this.stop;
    }

    public void setStop(long stop) {
        this.stop = stop;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public void setTotalBytes(long totalBytes) {
        this.totalBytes = totalBytes;
    }

    public void requestResponse(SOAPMessage request, SOAPMessage response, Context messageContext) {
        ++this.requests;
        if (response.isException()) {
            ++this.exceptions;
        } else {
            ++this.responses;
        }
        this.totalBytes += (long)(request.size() + response.size());
    }

    public void requestResponse(SOAPMessage request, Exception exception, Context messageContext) {
        ++this.requests;
        ++this.exceptions;
        this.totalBytes += (long)request.size();
    }

    public void add(PerformanceInfo performanceData) {
        this.requests += performanceData.requests;
        this.responses += performanceData.responses;
        this.exceptions += performanceData.exceptions;
        this.totalBytes += performanceData.totalBytes;
    }
}

