/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.console.services;

import electric.console.IConsoleConstants;
import electric.console.services.ConsoleModuleInfo;
import electric.console.services.IConsoleModule;
import electric.console.services.ITreeViewProducer;
import electric.console.util.ConsoleUtils;
import electric.fabric.Fabric;
import electric.fabric.console.services.IRulesConstants;
import electric.fabric.console.services.RuleComparator;
import electric.fabric.rules.Rule;
import electric.fabric.rules.RuleManagerException;
import electric.fabric.rules.actions.IAction;
import electric.fabric.rules.actions.email.SendEmail;
import electric.fabric.rules.actions.log.AddLogEntry;
import electric.fabric.rules.actions.message.SendMessage;
import electric.fabric.rules.conditions.IBinaryCondition;
import electric.fabric.rules.conditions.IUnaryCondition;
import electric.fabric.rules.conditions.size.MessageSizeThreshold;
import electric.fabric.rules.conditions.time.ResponseTimeThreshold;
import electric.fabric.rules.conditions.xpath.XPathMatch;
import electric.fabric.rules.processors.Processor;
import electric.fabric.rules.processors.filter.Filter;
import electric.fabric.rules.processors.monitor.Monitor;
import electric.fabric.rules.processors.transform.Transform;
import electric.fabric.rules.processors.transform.XSLTTransform;
import electric.util.array.ArrayUtil;
import electric.util.http.HTTPUtil;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.sorting.BubbleSort;
import electric.xdb.IXDBConstants;
import electric.xml.CData;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.ParseException;
import java.io.IOException;
import java.util.Hashtable;

public class Rules
implements ILoggingConstants,
IXDBConstants,
IConsoleModule,
ITreeViewProducer,
IRulesConstants,
IConsoleConstants {
    private ConsoleModuleInfo moduleInfo;
    private Hashtable ruleXSLTData = new Hashtable();

    public Document getRulesSummary() {
        try {
            Document doc = new Document();
            doc.setRoot("RuleEntries").setInt("numRules", Fabric.getRuleManager().getRuleCount());
            return doc;
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, "unable to get rule count", exception);
            }
            return new Document();
        }
    }

    public Document getRules(Hashtable args) throws RuleManagerException {
        String endpoint = (String)args.get("endpoint");
        try {
            Object[] rules = Fabric.getEndpointManager().getRulesForAllAndEndpoint(endpoint);
            BubbleSort.sort(rules, new RuleComparator());
            Document doc = new Document();
            Element root = doc.setRoot("ServiceRules");
            Element nodes = root.addElement("Rules");
            int i = 0;
            while (i < rules.length) {
                Object rule = rules[i];
                Processor processor = ((Rule)rule).getProcessor();
                Element node = nodes.addElement("Rule");
                node.setFloat("Priority", ((Rule)rule).getPriority());
                node.setString("URL", ((Rule)rule).getURL());
                node.setString("Key", ((Rule)rule).getKey());
                node.setString("Description", processor.toString());
                node.setString("RuleType", "General");
                if (processor instanceof Monitor) {
                    node.setString("RuleType", "Monitor");
                } else if (processor instanceof Filter) {
                    node.setString("RuleType", "Filter");
                } else if (processor instanceof Transform) {
                    node.setString("RuleType", "Transform");
                }
                ++i;
            }
            return doc;
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, "unable to get rules list", exception);
            }
            return new Document();
        }
    }

    public String deleteRule(Hashtable args) throws RuleManagerException {
        String key = (String)args.get("key");
        Fabric.getRuleManager().removeRule(key);
        return "&errorCode=0&message=none";
    }

    public Document getRuleInfo(Hashtable args) throws IOException, RuleManagerException {
        String key = (String)args.get("key");
        Rule rule = Fabric.getRuleManager().getRule(key);
        Processor processor = rule.getProcessor();
        Document doc = new Document();
        Element root = doc.setRoot("Rule");
        root.setFloat("Priority", rule.getPriority());
        root.setString("Key", rule.getKey());
        root.setString("URL", rule.getURL());
        Element processorNode = root.addElement("Processor");
        Element ruleTypeNode = processorNode.addElement("RuleType");
        String ruleType = "General";
        Element conditionsNode = new Element("Conditions");
        if (processor instanceof Monitor) {
            ruleType = "Monitor";
            Monitor monitor = (Monitor)processor;
            this.retrieveMonitorConditions(conditionsNode, monitor);
        } else if (processor instanceof Filter) {
            ruleType = "Filter";
            Filter filter = (Filter)processor;
            ruleTypeNode.setString("Code", filter.getCode());
            ruleTypeNode.setString("Message", filter.getMessage());
            this.retrieveFilterConditions(conditionsNode, filter);
        } else if (processor instanceof Transform) {
            ruleType = "Transform";
            Transform transform = (Transform)processor;
            this.retrieveTransformConditions(ruleTypeNode, transform, "key");
        }
        ruleTypeNode.setName(ruleType);
        if (!ruleType.equals("Transform")) {
            ruleTypeNode.addElement(conditionsNode);
        }
        return doc;
    }

    public String addRule(Hashtable args) {
        String addStatus = "&errorCode=0&message=none";
        try {
            Element ruleElement = new Document((String)args.get("ruleData")).getRoot();
            String url = HTTPUtil.decode(ruleElement.getString("URL"));
            String key = HTTPUtil.decode(ruleElement.getString("Key"));
            float priority = Float.parseFloat(ruleElement.getString("Priority"));
            Element processorElement = ruleElement.getElement("Processor").getFirstElement();
            Processor processor = this.parseProcessor(processorElement, key);
            Rule rule = new Rule(key, url, priority, processor);
            Fabric.getRuleManager().addRule(rule);
        }
        catch (Exception exception) {
            addStatus = "&errorCode=100&message=" + exception.toString();
            return addStatus;
        }
        return addStatus;
    }

    public String updateRule(Hashtable args) {
        return this.addRule(args);
    }

    private Processor parseProcessor(Element root, String key) throws IOException, ParseException {
        String name = root.getName();
        if (name.equals("Filter")) {
            return this.parseFilter(root);
        }
        if (name.equals("Monitor")) {
            return this.parseMonitor(root);
        }
        if (name.equals("Transform")) {
            return this.parserTransform(root, key);
        }
        return null;
    }

    private Processor parseFilter(Element root) {
        String message = root.getString("Message");
        String code = root.getString("Code");
        Element conditionsElement = root.getElement("Conditions");
        IUnaryCondition[] conditions = this.parseUnaryConditions(conditionsElement);
        return new Filter(message, code, conditions);
    }

    private void retrieveFilterConditions(Element conditionsNode, Filter filter) {
        IUnaryCondition[] conditions = filter.getConditions();
        this.setUpConditions(conditions, conditionsNode);
    }

    private Processor parseMonitor(Element root) {
        Element request = root.getElement("Request");
        Element requestConditionsElement = request.getElement("Conditions");
        IUnaryCondition[] requestConditions = this.parseUnaryConditions(requestConditionsElement);
        Element response = root.getElement("Response");
        Element responseConditionsElement = response.getElement("Conditions");
        IUnaryCondition[] responseConditions = this.parseUnaryConditions(responseConditionsElement);
        Element requestResponse = root.getElement("RequestResponse");
        Element requestResponseConditionsElement = requestResponse.getElement("Conditions");
        IBinaryCondition[] requestResponseConditions = this.parseBinaryConditions(requestResponseConditionsElement);
        Element actionsElement = root.getElement("Actions");
        IAction[] actions = this.parseActions(actionsElement);
        return new Monitor(requestConditions, responseConditions, requestResponseConditions, actions);
    }

    private void retrieveMonitorConditions(Element conditionsNode, Monitor monitor) {
        IUnaryCondition[] requestConditions = monitor.getRequestConditions();
        IUnaryCondition[] responseConditions = monitor.getResponseConditions();
        IBinaryCondition[] requestResponseConditions = monitor.getRequestResponseConditions();
        IAction[] actionConditions = monitor.getActions();
        Element requestNode = conditionsNode.addElement("Request");
        Element responseNode = conditionsNode.addElement("Response");
        Element responseRequestNode = conditionsNode.addElement("RequestResponse");
        Element actionsNode = conditionsNode.addElement("Actions");
        this.setUpConditions(requestConditions, requestNode);
        this.setUpConditions(responseConditions, responseNode);
        int i = 0;
        while (i < requestResponseConditions.length) {
            ResponseTimeThreshold condition = (ResponseTimeThreshold)requestResponseConditions[i];
            this.retrieveResponseTimeThreshold(responseRequestNode, condition);
            ++i;
        }
        int i2 = 0;
        while (i2 < actionConditions.length) {
            IAction condition;
            if (actionConditions[i2] instanceof AddLogEntry) {
                condition = (AddLogEntry)actionConditions[i2];
                this.retrieveAddLogEntry(actionsNode, (AddLogEntry)condition);
            } else if (actionConditions[i2] instanceof SendMessage) {
                condition = (SendMessage)actionConditions[i2];
                this.retrieveSendMessage(actionsNode, (SendMessage)condition);
            } else if (actionConditions[i2] instanceof SendEmail) {
                condition = (SendEmail)actionConditions[i2];
                this.retrieveSendEmail(actionsNode, (SendEmail)condition);
            }
            ++i2;
        }
    }

    private Processor parserTransform(Element root, String key) throws IOException, ParseException {
        Element requestElement = root.getElement("Request");
        XSLTTransform requestTransform = this.parseXSLTTransform(requestElement, key, "Request");
        Element responseElement = root.getElement("Response");
        XSLTTransform responseTransform = this.parseXSLTTransform(responseElement, key, "Response");
        if (this.ruleXSLTData.containsKey(key)) {
            this.ruleXSLTData.remove(key);
        }
        return new Transform(requestTransform, responseTransform);
    }

    private XSLTTransform parseXSLTTransform(Element root, String key, String transformType) throws IOException, ParseException {
        Element xslt;
        block8: {
            xslt = null;
            if (root.getString("XSLT").equals("null")) {
                Hashtable transformXSLT = (Hashtable)this.ruleXSLTData.get(key);
                if (transformXSLT != null) {
                    xslt = (Element)transformXSLT.get(transformType);
                } else {
                    try {
                        XSLTTransform existingXSLT = this.getXSLTFromTransform(key, transformType);
                        if (existingXSLT != null) {
                            xslt = existingXSLT.xslt;
                            break block8;
                        }
                        xslt = new Element();
                    }
                    catch (RuleManagerException exception) {
                        if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                            Log.log(ILoggingConstants.ERROR_EVENT, "unable to get XSLTTransform", exception);
                        }
                        xslt = new Element();
                    }
                }
            } else {
                byte[] bytes = ConsoleUtils.getUploadedFile(root.getString("XSLT"));
                Document document = new Document(bytes);
                xslt = document.getRoot();
            }
        }
        Element conditionsElement = root.getElement("Conditions");
        IUnaryCondition[] conditions = this.parseUnaryConditions(conditionsElement);
        return new XSLTTransform(xslt, conditions);
    }

    private XSLTTransform getXSLTFromTransform(String key, String transformType) throws RuleManagerException {
        XSLTTransform existingXSLT = new XSLTTransform();
        Rule rule = Fabric.getRuleManager().getRule(key);
        if (rule == null) {
            return existingXSLT;
        }
        Processor processor = rule.getProcessor();
        Transform transform = (Transform)processor;
        existingXSLT = transformType.equals("Request") ? transform.getRequestTransform() : transform.getResponseTransform();
        return existingXSLT;
    }

    private void retrieveTransformConditions(Element conditionsNode, Transform transform, String key) throws IOException {
        XSLTTransform xsltRequestTransform = transform.getRequestTransform();
        XSLTTransform xsltResponseTransform = transform.getResponseTransform();
        IUnaryCondition[] requestConditions = xsltRequestTransform.conditions;
        IUnaryCondition[] responseConditions = xsltResponseTransform.conditions;
        Element requestNode = conditionsNode.addElement("Request");
        Element responseNode = conditionsNode.addElement("Response");
        Element requestXSLT = xsltRequestTransform.xslt;
        Element responseXSLT = xsltResponseTransform.xslt;
        Hashtable<String, Element> transformXSLT = new Hashtable<String, Element>();
        transformXSLT.put("Request", requestXSLT);
        transformXSLT.put("Response", responseXSLT);
        this.ruleXSLTData.put(key, transformXSLT);
        ConsoleUtils consoleUtil = new ConsoleUtils();
        requestNode.addElement("XSLT").setText(new CData(consoleUtil.changeToConsoleNodeWriter(requestXSLT)));
        responseNode.addElement("XSLT").setText(new CData(consoleUtil.changeToConsoleNodeWriter(responseXSLT)));
        Element requestConditionsNode = requestNode.addElement("Conditions");
        Element responseConditionsNode = responseNode.addElement("Conditions");
        this.setUpConditions(requestConditions, requestConditionsNode);
        this.setUpConditions(responseConditions, responseConditionsNode);
    }

    private IUnaryCondition[] parseUnaryConditions(Element root) {
        IUnaryCondition[] array = new IUnaryCondition[]{};
        Elements children = root.getElements();
        while (children.hasMoreElements()) {
            IUnaryCondition unaryCondition = this.parseUnaryCondition(children.next());
            array = (IUnaryCondition[])ArrayUtil.addElement(array, unaryCondition);
        }
        return array;
    }

    private IUnaryCondition parseUnaryCondition(Element root) {
        String name = root.getName();
        if (name.equals("MessageSizeThreshold")) {
            return this.parseMessageSizeThreshold(root);
        }
        if (name.equals("XPathMatch")) {
            return this.parseXPathMatch(root);
        }
        return null;
    }

    private MessageSizeThreshold parseMessageSizeThreshold(Element root) {
        Element data = root.getElement("data");
        int threshold = data.getInt("Threshold");
        return new MessageSizeThreshold(threshold);
    }

    private XPathMatch parseXPathMatch(Element root) {
        Element data = root.getElement("data");
        String path = data.getString("Path");
        String mode = data.getString("Mode");
        XPathMatch xpathMatch = new XPathMatch(path, mode);
        Element prefixNamespacePairs = data.getElement("PrefixNamespacePairs");
        Elements prefixNamespaces = prefixNamespacePairs.getElements("PrefixNamespace");
        while (prefixNamespaces.hasMoreElements()) {
            Element prefixNamespace = prefixNamespaces.next();
            String prefix = prefixNamespace.getString("Prefix");
            String namespace = prefixNamespace.getString("Namespace");
            xpathMatch.addNamespace(prefix, namespace);
        }
        return xpathMatch;
    }

    private void retrieveMessageSizeThreshold(Element conditionsNode, MessageSizeThreshold mst) {
        conditionsNode.setInt("MessageSizeThreshold", mst.threshold);
    }

    private void retrieveXPathMatch(Element conditionsNode, XPathMatch xPathMatch) {
        String[] prefixes = xPathMatch.prefixes;
        String[] namespaces = xPathMatch.namespaces;
        String path = xPathMatch.path;
        int mode = xPathMatch.mode;
        conditionsNode.setString("Path", path);
        conditionsNode.setInt("Mode", mode);
        int i = 0;
        while (i < prefixes.length) {
            Element prefixNamespace = conditionsNode.addElement("PrefixNamespace");
            prefixNamespace.setString("Prefix", prefixes[i]);
            prefixNamespace.setString("Namespace", namespaces[i]);
            ++i;
        }
    }

    private IBinaryCondition[] parseBinaryConditions(Element root) {
        IBinaryCondition[] array = new IBinaryCondition[]{};
        Elements children = root.getElements();
        while (children.hasMoreElements()) {
            IBinaryCondition binaryCondition = this.parseBinaryCondition(children.next());
            array = (IBinaryCondition[])ArrayUtil.addElement(array, binaryCondition);
        }
        return array;
    }

    private IBinaryCondition parseBinaryCondition(Element root) {
        String name = root.getName();
        if (name.equals("ResponseTimeThreshold")) {
            return this.parseResponseTimeThreshold(root);
        }
        return null;
    }

    private ResponseTimeThreshold parseResponseTimeThreshold(Element root) {
        Element data = root.getElement("data");
        int threshold = data.getInt("Threshold");
        return new ResponseTimeThreshold(threshold);
    }

    private void retrieveResponseTimeThreshold(Element conditionsNode, ResponseTimeThreshold rtt) {
        conditionsNode.setLong("ResponseTimeThreshold", rtt.getThreshold());
    }

    private IAction[] parseActions(Element root) {
        IAction[] array = new IAction[]{};
        Elements children = root.getElements();
        while (children.hasMoreElements()) {
            IAction action = this.parseAction(children.next());
            array = (IAction[])ArrayUtil.addElement(array, action);
        }
        return array;
    }

    private IAction parseAction(Element root) {
        String name = root.getName();
        if (name.equals("AddLogEntry")) {
            return this.parseAddLogEntry(root);
        }
        if (name.equals("SendMessage")) {
            return this.parseSendMessage(root);
        }
        return null;
    }

    private AddLogEntry parseAddLogEntry(Element root) {
        Element data = root.getElement("data");
        String category = data.getString("Category");
        String message = data.getString("Message");
        return new AddLogEntry(category, message);
    }

    private SendMessage parseSendMessage(Element root) {
        Element data = root.getElement("data");
        String url = data.getString("URL");
        String operation = data.getString("Operation");
        String message = data.getString("Message");
        SendMessage result = new SendMessage(url, operation, message);
        result.includeRequest = data.getBoolean("IncludeRequest");
        result.includeResponse = data.getBoolean("IncludeResponse");
        result.includeTimestamp = data.getBoolean("IncludeTimestamp");
        return result;
    }

    private void retrieveAddLogEntry(Element conditionsNode, AddLogEntry logEntry) {
        Element action = conditionsNode.addElement("AddLogEntry");
        action.setString("Category", logEntry.category);
        action.setString("Message", logEntry.message);
    }

    private void retrieveSendMessage(Element conditionsNode, SendMessage message) {
        Element action = conditionsNode.addElement("SendMessage");
        action.setString("URL", message.url);
        action.setString("OperationName", message.operation);
        action.setString("Message", message.message);
        action.setBoolean("IncludeTimestamp", message.includeTimestamp);
        action.setBoolean("IncludeResponse", message.includeResponse);
        action.setBoolean("IncludeRequest", message.includeRequest);
    }

    private void retrieveSendEmail(Element conditionsNode, SendEmail email) {
    }

    private void setUpConditions(IUnaryCondition[] conditions, Element conditionsNode) {
        int i = 0;
        while (i < conditions.length) {
            IUnaryCondition condition;
            if (conditions[i] instanceof MessageSizeThreshold) {
                condition = (MessageSizeThreshold)conditions[i];
                this.retrieveMessageSizeThreshold(conditionsNode, (MessageSizeThreshold)condition);
            } else {
                condition = (XPathMatch)conditions[i];
                Element xPathNode = conditionsNode.addElement("XPathMatch");
                this.retrieveXPathMatch(xPathNode, (XPathMatch)condition);
            }
            ++i;
        }
    }

    public Element[] getConsoleTreeViewElement(String sessionID) {
        Element element = new Element("TREE");
        element.addText("Rules");
        element.setAttribute("Name", "Rules");
        element.setAttribute("Function", "showDetails");
        element.setAttribute("TARGET", "_root");
        element.setAttribute("HeaderText", "Rules");
        element.setAttribute("swfURL", this.moduleInfo.getSWFURL());
        element.setAttribute("helpfileURL", this.moduleInfo.getHelpFileURL());
        element.setAttribute("serviceURL", this.moduleInfo.getServiceURL());
        return new Element[]{element};
    }

    public boolean isSessionAware() {
        return false;
    }

    public void setConsoleModuleInfo(ConsoleModuleInfo moduleInfo) {
        this.moduleInfo = moduleInfo;
    }
}

