/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.console.services;

import electric.console.IConsoleConstants;
import electric.console.services.ConsoleModuleInfo;
import electric.console.services.IConsoleModule;
import electric.console.services.ITreeViewProducer;
import electric.fabric.Fabric;
import electric.fabric.console.services.IConfigurationConstants;
import electric.fabric.endpoints.EndpointRefresher;
import electric.fabric.nodes.liveness.NodeLiveness;
import electric.fabric.services.broker.locators.subnet.SubnetLocator;
import electric.fabric.services.liveness.ServiceLiveness;
import electric.util.log.ILoggingConstants;
import electric.xdb.server.XDBServer;
import electric.xml.Document;
import electric.xml.Element;

public class Configuration
implements ILoggingConstants,
IConsoleModule,
ITreeViewProducer,
IConfigurationConstants,
IConsoleConstants {
    private ConsoleModuleInfo moduleInfo;

    public Document getConfigurationData() {
        Document document = new Document();
        Element configuration = document.setRoot("Configuration");
        Element details = configuration.addElement("Details");
        details.setInt("RulesRefresh", (int)(EndpointRefresher.getRefreshCycle() / 1000L));
        details.setInt("XMLDatabaseSynch", (int)(XDBServer.getSyncCycle() / 1000L));
        details.setInt("NodeLivenessCheck", (int)(NodeLiveness.getLivenessCycle() / 1000L));
        details.setInt("NodeLivenessReap", (int)(NodeLiveness.getReapThreshold() / 1000L));
        details.setInt("ServiceLivenessCheck", (int)(ServiceLiveness.getLivenessCycle() / 1000L));
        details.setInt("ServiceLivenessReap", (int)(ServiceLiveness.getReapThreshold() / 1000L));
        SubnetLocator subnetLocator = (SubnetLocator)Fabric.getServiceManager().getBrokerLocator();
        details.setInt("BroadcastPort", subnetLocator.getPort());
        details.setInt("SubnetDiscoveryPing", subnetLocator.getPingCycle() / 1000);
        return document;
    }

    public Element[] getConsoleTreeViewElement(String sessionID) {
        Element element = new Element("TREE");
        element.addText("Configuration");
        element.setAttribute("Name", "Configuration");
        element.setAttribute("Function", "showDetails");
        element.setAttribute("TARGET", "_root");
        element.setAttribute("HeaderText", "Configuration");
        element.setAttribute("swfURL", this.moduleInfo.getSWFURL());
        element.setAttribute("helpfileURL", this.moduleInfo.getHelpFileURL());
        element.setAttribute("serviceURL", this.moduleInfo.getServiceURL());
        return new Element[]{element};
    }

    public boolean isSessionAware() {
        return false;
    }

    public void setConsoleModuleInfo(ConsoleModuleInfo moduleInfo) {
        this.moduleInfo = moduleInfo;
    }
}

