/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.config;

import electric.fabric.Fabric;
import electric.fabric.config.IFabricConfigConstants;
import electric.fabric.services.broker.IBrokerLocator;
import electric.glue.IGLUELoggingConstants;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.product.IConfig;
import electric.util.reflect.Creator;
import electric.xml.Element;
import electric.xml.Elements;

public final class DiscoveryConfig
implements IConfig,
IFabricConfigConstants,
IGLUELoggingConstants {
    public void config(Element config) {
        Element discovery = config.getElement("discovery");
        String noPath = discovery.getString("noPath");
        Fabric.setNoPath(noPath);
        Elements locatorElements = discovery.getElements("locator");
        while (locatorElements.hasMoreElements()) {
            Element locatorElement = locatorElements.next();
            try {
                String name = locatorElement.getString("name");
                IBrokerLocator locator = (IBrokerLocator)Creator.newInstance(locatorElement, null);
                Fabric.getServiceManager().addBrokerLocator(name, locator);
            }
            catch (Throwable throwable) {
                if (!Log.isLogging(ILoggingConstants.STARTUP_EVENT)) continue;
                Log.log(ILoggingConstants.STARTUP_EVENT, (Object)("could not materialize data server locator " + locatorElement + "\n" + throwable.toString()));
            }
        }
        String useLocator = discovery.getString("useLocator");
        Fabric.getServiceManager().setBrokerLocator(useLocator);
    }
}

