/*
 * Decompiled with CFR 0.152.
 */
package electric.cluster.server;

import electric.cluster.IClusterConstants;
import electric.cluster.server.IApplicationServer;
import electric.glue.IGLUELoggingConstants;
import electric.util.directory.monitored.IFileEventListener;
import electric.util.directory.monitored.MonitoredRoot;
import electric.util.file.FileUtil;
import electric.util.jar.Jar;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.thread.Lock;
import java.io.File;
import java.io.FileInputStream;
import java.util.zip.ZipInputStream;

public class AppServerMonitor
implements IFileEventListener,
IGLUELoggingConstants,
IClusterConstants {
    private MonitoredRoot root;
    private IApplicationServer server;

    public AppServerMonitor(File rootDirectory, IApplicationServer server) {
        this.server = server;
        this.root = new MonitoredRoot(rootDirectory);
        this.root.addEventListener(this);
    }

    public void start() {
        this.root.start();
    }

    public void stop() {
        this.root.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filesAdded(File[] files) {
        int i = 0;
        while (i < files.length) {
            Object var11_11;
            File file = files[i];
            String fileName = file.getName();
            int lastIndex = -1;
            Lock lock = null;
            try {
                block11: {
                    try {
                        String filePath = file.getCanonicalPath();
                        lastIndex = filePath.toLowerCase().lastIndexOf(".war");
                        if (lastIndex != -1) {
                            File directory = new File(filePath.substring(0, lastIndex));
                            if (!directory.exists()) {
                                lock = Lock.obtain(fileName);
                                ZipInputStream stream = new ZipInputStream(new FileInputStream(file));
                                Jar.unjarFile(directory, stream);
                            }
                            FileUtil.delete(file);
                            break block11;
                        }
                        if (!file.isDirectory()) break block11;
                        this.server.addApplication(file);
                    }
                    catch (Exception exception) {
                        if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                            Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception adding file to application server: " + fileName, exception);
                        }
                        var11_11 = null;
                        if (lock != null) {
                            lock.release();
                        }
                    }
                }
                var11_11 = null;
                if (lock != null) {
                    lock.release();
                }
            }
            catch (Throwable throwable) {
                var11_11 = null;
                if (lock != null) {
                    lock.release();
                }
                throw throwable;
            }
            ++i;
        }
    }

    public void filesRemoved(File[] files) {
        int i = 0;
        while (i < files.length) {
            block5: {
                File file = files[i];
                try {
                    String applicationPath = file.getCanonicalPath();
                    if (Log.isLogging(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT)) {
                        Log.log(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT, (Object)("file deleted from application: " + applicationPath));
                    }
                    if (this.server.applicationExists(applicationPath)) {
                        this.server.removeApplication(file, true);
                    }
                }
                catch (Exception exception) {
                    if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block5;
                    Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception removing file to application server: " + file, exception);
                }
            }
            ++i;
        }
    }

    public void filesModified(File[] files) {
    }
}

