/*
 * Decompiled with CFR 0.152.
 */
package electric.cluster.dispatcher;

import electric.cluster.IClusterConstants;
import electric.cluster.IClusteredApplication;
import electric.cluster.httpoversoap.HTTPRequestInfo;
import electric.fabric.Fabric;
import electric.fabric.IFabricConstants;
import electric.glue.IGLUELoggingConstants;
import electric.glue.context.ProxyContext;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.util.Context;
import electric.util.io.Streams;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.mime.MIMEData;
import electric.util.mime.MIMEHeaders;
import electric.util.mime.MemoryDataHandler;
import electric.util.string.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DispatcherServlet
extends HttpServlet
implements IClusterConstants,
IFabricConstants,
IGLUELoggingConstants {
    private static final byte[] EMPTY_ARRAY = new byte[0];
    private Hashtable nameToApplication = new Hashtable();
    private String balancingUrl;
    private boolean perMsgBalancing = false;
    static /* synthetic */ Class class$electric$cluster$IClusteredApplication;

    public void init(ServletConfig servletConfig) throws ServletException {
        String perMessageBalancing = servletConfig.getInitParameter("perMessageBalancing");
        this.perMsgBalancing = Strings.getBoolean(perMessageBalancing, false);
        this.balancingUrl = "fabric://failover&balance&service.online=true&service.appName=";
        try {
            Fabric.join();
        }
        catch (Throwable throwable) {
            throw new ServletException(throwable);
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        if (Log.isLogging(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT)) {
            Log.log(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT, (Object)("pathinfo is " + pathInfo));
        }
        if (pathInfo == null || pathInfo.length() == 0) {
            response.setStatus(204);
            return;
        }
        if (pathInfo.startsWith("/")) {
            pathInfo = pathInfo.substring(1);
        }
        String appName = pathInfo;
        if (pathInfo.indexOf(47) != -1) {
            appName = pathInfo.substring(0, pathInfo.indexOf(47));
        }
        if (this.isWSDLRequest(pathInfo)) {
            if (Log.isLogging(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT)) {
                Log.log(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT, (Object)"rerouting wsdl request to /wsdl");
            }
            String registryPath = pathInfo.substring((appName + "/services/").length());
            registryPath = registryPath.substring(0, registryPath.indexOf(".wsdl"));
            request.setAttribute("queryString", (Object)("failover&" + (this.perMsgBalancing ? "balance&" : "") + "service.appName=" + appName + "&service.registryPath=" + registryPath));
            RequestDispatcher dispatcher = request.getRequestDispatcher("/wsdl");
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        } else {
            this.handleNonSOAPRequest(pathInfo, appName, request, response);
        }
    }

    private void handleNonSOAPRequest(String pathInfo, String appName, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HTTPRequestInfo requestInfo = new HTTPRequestInfo();
        MIMEHeaders mimeHeaders = new MIMEHeaders();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration headerValues = request.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                mimeHeaders.addHeader(headerName, (String)headerValues.nextElement());
            }
        }
        requestInfo.setMIMEHeaders(mimeHeaders);
        String queryString = request.getQueryString();
        String requestUri = pathInfo.substring(appName.length());
        String string = requestUri = queryString == null ? requestUri : requestUri + "?" + queryString;
        if (requestUri.length() == 0) {
            requestUri = requestUri + "/";
        }
        requestInfo.setRequestURI(requestUri);
        requestInfo.setDispatcherContextPath(request.getContextPath());
        if (Log.isLogging(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT)) {
            Log.log(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT, (Object)("path info: " + pathInfo));
            Log.log(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT, (Object)("request type: " + request.getMethod()));
            Log.log(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT, (Object)("request content length: " + request.getContentLength()));
            Log.log(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT, (Object)("request uri: " + requestUri));
            Log.log(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT, (Object)("dispatcher context path: " + request.getContextPath()));
        }
        String httpMethod = request.getMethod();
        requestInfo.setRequestType(httpMethod);
        if (httpMethod.equalsIgnoreCase("POST")) {
            requestInfo.setBodyBytes(Streams.readFully((InputStream)request.getInputStream(), request.getContentLength()));
        } else {
            requestInfo.setBodyBytes(EMPTY_ARRAY);
        }
        IClusteredApplication application = this.getApplication(appName);
        if (application == null) {
            response.setStatus(503);
            return;
        }
        MIMEData mimeResponse = application.handleNonSOAPRequest(requestInfo);
        byte[] contentBytes = mimeResponse.getBytes();
        if (Log.isLogging(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT)) {
            Log.log(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT, (Object)("returning content: " + new String(contentBytes)));
        }
        response.getOutputStream().write(contentBytes);
        mimeResponse.getInputStream().close();
        mimeResponse.dispose();
    }

    private IClusteredApplication getApplication(String name) {
        IClusteredApplication application = (IClusteredApplication)this.nameToApplication.get(name);
        if (application != null) {
            return application;
        }
        try {
            ProxyContext context = new ProxyContext();
            MemoryDataHandler dataHandler = new MemoryDataHandler();
            context.setProperty("*/* dataHandler", dataHandler);
            application = (IClusteredApplication)Registry.bind(this.balancingUrl + name, class$electric$cluster$IClusteredApplication == null ? (class$electric$cluster$IClusteredApplication = DispatcherServlet.class$("electric.cluster.IClusteredApplication")) : class$electric$cluster$IClusteredApplication, (Context)context);
        }
        catch (RegistryException exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
            }
            return null;
        }
        this.nameToApplication.put(name, application);
        return application;
    }

    private boolean isWSDLRequest(String requestPathInfo) {
        if (requestPathInfo == null) {
            return false;
        }
        String extension = Strings.extension(requestPathInfo);
        return extension != null && extension.equalsIgnoreCase("wsdl");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

