/*
 * Decompiled with CFR 0.152.
 */
package electric.cluster;

import electric.application.web.WebApplication;
import electric.cluster.IClusterConstants;
import electric.cluster.IClusteredApplication;
import electric.cluster.httpoversoap.ContentOnlyHTTPResponse;
import electric.cluster.httpoversoap.HTTPRequestInfo;
import electric.cluster.httpoversoap.StaticChannel;
import electric.cluster.monitor.ClusteredAppMonitor;
import electric.glue.IGLUELoggingConstants;
import electric.glue.context.ThreadContext;
import electric.glue.enterprise.config.Config;
import electric.servlet.HTTPContext;
import electric.servlet.InboundHTTPRequest;
import electric.servlet.MappedServlet;
import electric.servlet.dispatcher.ServletRequestDispatcher;
import electric.util.log.Log;
import electric.util.mime.MIMEData;
import electric.util.product.Product;
import electric.util.string.Strings;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class ClusteredApplication
extends WebApplication
implements IClusteredApplication,
IClusterConstants {
    private boolean master;
    private String applicationRoot;
    private ClusteredAppMonitor clusteredAppMonitor;
    private boolean started = false;

    public ClusteredApplication(String applicationRoot, String appURL, boolean master) {
        super(applicationRoot, appURL);
        this.applicationRoot = applicationRoot;
        this.master = master;
    }

    public void start() {
        if (this.started) {
            return;
        }
        try {
            Product.addPlugin(new Config());
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString());
        }
        super.start();
        if (this.master) {
            this.startMonitor();
        }
        this.started = true;
    }

    public void stop() {
        if (this.started) {
            super.stop();
            if (this.master) {
                this.clusteredAppMonitor.stop();
            }
        }
        this.started = false;
    }

    private void startMonitor() {
        File file = new File(this.applicationRoot);
        this.clusteredAppMonitor = new ClusteredAppMonitor(file.getName(), this.applicationRoot);
        this.clusteredAppMonitor.start();
    }

    public MIMEData handleNonSOAPRequest(HTTPRequestInfo requestInfo) {
        MIMEData responseData;
        block7: {
            responseData = null;
            StaticChannel channel = new StaticChannel(requestInfo);
            InboundHTTPRequest servletRequest = new InboundHTTPRequest(channel);
            try {
                servletRequest.readHeaders();
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
            if (Log.isLogging(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT)) {
                Log.log(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT, (Object)requestInfo.toString());
            }
            ContentOnlyHTTPResponse servletResponse = new ContentOnlyHTTPResponse();
            servletResponse.setChannel(channel);
            servletRequest.setHTTPResponse(servletResponse);
            ServletContext servletContext = ThreadContext.getHttpServletConfig().getServletContext();
            ServletRequestDispatcher dispatcher = (ServletRequestDispatcher)servletContext.getRequestDispatcher(requestInfo.getRequestURI());
            MappedServlet servlet = dispatcher.getMapppedServlet();
            HTTPContext context = servlet.config.getContext();
            String oldPath = context.getPath();
            context.setPath(Strings.splice(requestInfo.getDispatcherPath(), oldPath));
            servletRequest.setConfig(servlet.config);
            servletRequest.setPathInfo(servlet.pathInfo);
            servletRequest.setServletPath(servlet.servletPath);
            try {
                dispatcher.forward((ServletRequest)servletRequest, (ServletResponse)servletResponse);
                context.setPath(oldPath);
                if (servletResponse.isRedirect()) {
                    String prefix;
                    String redirectLocation = servletResponse.getRedirectLocation();
                    if (redirectLocation.startsWith(prefix = Strings.splice(requestInfo.getDispatcherPath(), this.getAppName()))) {
                        redirectLocation = redirectLocation.substring(prefix.length());
                    }
                    requestInfo.setRequestURI(redirectLocation);
                    return this.handleNonSOAPRequest(requestInfo);
                }
                byte[] response = ((ByteArrayOutputStream)channel.getOutputStream()).toByteArray();
                responseData = new MIMEData(response);
            }
            catch (Exception exception) {
                if (!Log.isLogging(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT)) break block7;
                Log.log(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT, "exception: " + exception, exception);
            }
        }
        return responseData;
    }
}

