/*
 * Decompiled with CFR 0.152.
 */
package electric.application.web.servlets;

import electric.application.web.WebApplication;
import electric.glue.IGLUELoggingConstants;
import electric.util.directory.filters.ExtensionFilter;
import electric.util.directory.monitored.IFileEventListener;
import electric.util.directory.monitored.MonitoredDirectory;
import electric.util.directory.monitored.MonitoredRoot;
import electric.util.file.FileUtil;
import electric.util.log.Log;
import java.io.File;
import java.io.FilenameFilter;

public final class JSPMonitor
implements IFileEventListener,
IGLUELoggingConstants {
    private MonitoredRoot root;
    private FilenameFilter tempFilter;
    private File tempDir;

    public JSPMonitor(WebApplication application) {
        this.tempDir = new File(application.getTmpRoot());
        this.tempFilter = new ExtensionFilter(new String[]{".java", ".class"});
        ExtensionFilter filter = new ExtensionFilter(new String[]{".jsp"});
        this.root = new MonitoredRoot(new File(application.getAppPath()), true, false, filter, true);
        MonitoredDirectory syncRoot = this.root.getRoot();
        syncRoot.removeSubDirectory(new File(this.tempDir.getParent()).getName());
        this.root.addEventListener(this);
    }

    public void start() {
        this.root.start();
    }

    public void stop() {
        this.root.stop();
    }

    public void filesAdded(File[] files) {
    }

    public void filesRemoved(File[] files) {
        if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
            Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)"some jsp files were removed, cleaning out WEB-INF\\tmp");
        }
        this.clearOutTmpDir();
    }

    public void filesModified(File[] files) {
        if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
            Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)"some jsp files were modified, cleaning out WEB-INF\\tmp");
        }
        this.clearOutTmpDir();
    }

    private void clearOutTmpDir() {
        FileUtil.delete(this.tempDir, true, this.tempFilter);
    }
}

