/*
 * Decompiled with CFR 0.152.
 */
package electric.application.web.services;

import electric.application.web.services.ServiceManager;
import electric.glue.IGLUELoggingConstants;
import electric.util.directory.filters.ExtensionFilter;
import electric.util.directory.monitored.IFileEventListener;
import electric.util.directory.monitored.MonitoredRoot;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.xml.Document;
import electric.xml.ParseException;
import java.io.File;

public final class ServiceMonitor
implements IFileEventListener,
IGLUELoggingConstants {
    private ServiceManager serviceManager;
    private MonitoredRoot root;

    public ServiceMonitor(ServiceManager serviceManager, String path) {
        this.serviceManager = serviceManager;
        ExtensionFilter filter = new ExtensionFilter(new String[]{".xml"});
        this.root = new MonitoredRoot(new File(path), true, false, filter, true);
        this.root.addEventListener(this);
    }

    public void start() {
        this.root.start();
    }

    public void stop() {
        this.root.stop();
    }

    public void cycle() {
        this.root.cycle();
    }

    public void filesAdded(File[] files) {
        int i = 0;
        while (i < files.length) {
            this.descriptorAdded(files[i]);
            ++i;
        }
    }

    public void filesRemoved(File[] files) {
        int i = 0;
        while (i < files.length) {
            this.descriptorRemoved(files[i]);
            ++i;
        }
    }

    public void filesModified(File[] files) {
        int i = 0;
        while (i < files.length) {
            this.descriptorModified(files[i]);
            ++i;
        }
    }

    private void descriptorAdded(File file) {
        block2: {
            try {
                this.serviceManager.descriptorAdded(file.getAbsolutePath(), new Document(file));
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) break block2;
                Log.log(ILoggingConstants.ERROR_EVENT, this.getAppName() + ": could not add service " + file.getAbsolutePath(), exception);
            }
        }
    }

    private void descriptorRemoved(File file) {
        this.serviceManager.descriptorRemoved(file.getAbsolutePath());
    }

    private void descriptorModified(File file) {
        block2: {
            try {
                this.serviceManager.descriptorModified(file.getAbsolutePath(), new Document(file));
            }
            catch (ParseException exception) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) break block2;
                Log.log(ILoggingConstants.ERROR_EVENT, this.getAppName() + ": could not restart service " + file.getAbsolutePath(), exception);
            }
        }
    }

    private String getAppName() {
        return this.serviceManager.getAppName();
    }
}

