/*
 * Decompiled with CFR 0.152.
 */
package electric.application.web;

import electric.application.web.IStateConstants;
import electric.application.web.WebApplication;
import electric.application.web.classes.ClassManager;
import electric.application.web.classes.ClassMonitor;
import electric.application.web.classes.IClassConstants;
import electric.application.web.config.ConfigMonitor;
import electric.glue.IGLUELoggingConstants;
import electric.util.classloader.ClassLoaders;
import electric.util.classloader.TrackingClassLoader;
import electric.util.classloader.filters.IClassFilter;
import electric.util.classpath.ClassPathSource;
import electric.util.classpath.IClassPathEventListener;
import electric.util.classpath.IClassPathSource;
import electric.util.constructor.Constructor;
import electric.util.constructor.IInstantiator;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.thread.IdleTask;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;

public class WebAppMonitor
implements IStateConstants,
IClassPathEventListener,
IClassConstants,
IGLUELoggingConstants {
    private ClassMonitor classPathMonitor;
    private ClassPathSource classPathSource;
    private TrackingClassLoader classLoader;
    private String appPath;
    private String appURL;
    private Object application;
    private int mode = 4;
    private boolean shouldMonitor = true;
    private ConfigMonitor configMonitor;
    private static final String DEFAULT_CLASS = "electric.application.web.WebApplication";
    private String className;
    private IInstantiator constructor;
    static /* synthetic */ Class class$java$lang$String;

    public WebAppMonitor(File appDir, String appURL) throws IOException {
        this(appDir, appURL, null);
    }

    public WebAppMonitor(File appDir, String appURL, IInstantiator constructor) throws IOException {
        this.appURL = appURL;
        this.appPath = appDir.getCanonicalPath();
        if (!this.appPath.endsWith(File.separator)) {
            this.appPath = this.appPath + File.separator;
        }
        if (constructor == null) {
            Class[] argTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = WebAppMonitor.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = WebAppMonitor.class$("java.lang.String")) : class$java$lang$String};
            String[] args = new String[]{this.appPath, this.appURL};
            this.constructor = new Constructor(DEFAULT_CLASS, argTypes, args);
        } else {
            this.constructor = constructor;
        }
        this.className = this.constructor.getClassName();
        String webInfRoot = this.appPath + "WEB-INF" + File.separator;
        this.classPathSource = ClassManager.newClassPathSource(webInfRoot);
        if (WebApplication.isHotDeploy()) {
            IClassPathEventListener[] listeners = new IClassPathEventListener[]{this.classPathSource, this};
            this.classPathMonitor = new ClassMonitor(webInfRoot, listeners);
            this.classPathMonitor.start();
            this.configMonitor = new ConfigMonitor(this, webInfRoot);
        }
    }

    private synchronized Object getApplication() throws Exception {
        if (this.application != null) {
            return this.application;
        }
        IClassFilter[] filters = new IClassFilter[]{};
        this.classLoader = new TrackingClassLoader((IClassPathSource)this.classPathSource, filters);
        Class appClass = this.classLoader.loadClass(this.className);
        if (!appClass.getClassLoader().equals(this.classLoader) && this.className.equals(DEFAULT_CLASS)) {
            this.shouldMonitor = false;
            this.constructor.setClassLoader(appClass.getClassLoader());
        } else {
            this.constructor.setClassLoader(this.classLoader);
        }
        try {
            this.application = this.constructor.newInstance();
            return this.application;
        }
        catch (Exception exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new Exception(throwable.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        this.mode = 2;
        Object application = this.getApplication();
        Method start = application.getClass().getMethod("start", new Class[0]);
        ClassLoader previousContextLoader = ClassLoaders.getContextClassLoader();
        ClassLoaders.setContextClassLoader(this.classLoader);
        try {
            start.invoke(application, new Object[0]);
            this.configMonitor.start();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ClassLoaders.setContextClassLoader(previousContextLoader);
            throw throwable;
        }
        ClassLoaders.setContextClassLoader(previousContextLoader);
        this.mode = 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        if (this.mode == 3) {
            Method stop = this.application.getClass().getMethod("stop", new Class[0]);
            ClassLoader previousContextLoader = ClassLoaders.getContextClassLoader();
            ClassLoaders.setContextClassLoader(this.classLoader);
            try {
                stop.invoke(this.application, new Object[0]);
                this.configMonitor.stop();
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                ClassLoaders.setContextClassLoader(previousContextLoader);
                throw throwable;
            }
            ClassLoaders.setContextClassLoader(previousContextLoader);
            {
            }
        }
        this.mode = 4;
        this.application = null;
    }

    public void restart() throws Exception {
        IdleTask task = new IdleTask();
        this.stop();
        this.start();
        task.stop();
    }

    public void classesAdded(File[] files) {
        block2: {
            if (this.mode != 2) break block2;
            try {
                this.start();
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) break block2;
                Log.log(ILoggingConstants.ERROR_EVENT, "could not start application", exception);
            }
        }
    }

    public void classesRemoved(File[] files) {
        block2: {
            if (!this.shouldMonitor || !this.classLoader.usesFiles(files)) break block2;
            try {
                this.stop();
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) break block2;
                Log.log(ILoggingConstants.ERROR_EVENT, "could not stop application", exception);
            }
        }
    }

    public void classesModified(File[] files) {
        block3: {
            try {
                if (this.shouldMonitor) {
                    this.restart();
                }
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) break block3;
                Log.log(ILoggingConstants.ERROR_EVENT, "could not restart application", exception);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

