/*
 * Decompiled with CFR 0.152.
 */
package electric.application.tools;

import electric.application.tools.Utils;
import electric.application.web.WebAppMonitor;
import electric.application.web.WebApplication;
import electric.fabric.Fabric;
import electric.util.array.ArrayUtil;
import electric.util.tool.ToolUtil;
import java.io.File;

public class RunApp {
    private static String[] appPaths = new String[0];
    private static boolean runAllApps;
    private static String appURL;
    private static boolean fabric;
    private static int discoveryPort;

    public static void main(String[] args) {
        if (args.length == 0) {
            RunApp.printUsage();
            return;
        }
        try {
            RunApp.processArgs(args);
            RunApp.runapp();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            RunApp.printUsage();
            System.exit(-1);
        }
    }

    private static void printUsage() {
        System.out.println("usage: runapp [-jaas policyfile] [-Dname=value]* [-h] {appname+ | -a} [-f [port]] {[-p port] | [-u url]}");
        System.out.println();
        System.out.println("where:");
        System.out.println("  -jaas policyfile = turn on java2 security using the specified policy file");
        System.out.println("  -Dname=value     = set java system property");
        System.out.println("  appname          = name of the application to run");
        System.out.println("  -a               = run all applications under application home");
        System.out.println("  -f [port]        = join fabric (default port is 9030)");
        System.out.println("  -h               = print help and exit");
        System.out.println("  -p port          = run app on specified port");
        System.out.println("  -u url           = run app on specified url");
        System.out.println();
        System.out.println("by default, an application called myapp will start on");
        System.out.println("http://localhost:8004/myapp. the -p and -u options allow");
        System.out.println("you to override the port or entire startup URL, respectively.");
        System.out.println();
        System.out.println("an application name can be specified as a relative or absolute path.");
        System.out.println("by default, relative paths are resolved from the current directory.");
        System.out.println("if you prefer that applications share a common home,");
        System.out.println("set the environment variable GLUE_APPHOME or the Java");
        System.out.println("system property glue.apphome to the application home directory.");
        System.out.println("relative paths are then resolved relative to the application home.");
        System.out.println();
        System.out.println("examples:");
        System.out.println();
        System.out.println("runapp app1");
        System.out.println("  run application called app1 on http://localhost:8004/app1");
        System.out.println();
        System.out.println("runapp app1 -p 8080");
        System.out.println("  run application called app1 on http://localhost:8080/app1");
        System.out.println();
        System.out.println("runapp app1 -u http://localhost:8080/myapp");
        System.out.println("  run application called app1 on http://localhost:8080/myapp");
        System.out.println();
        System.out.println("runapp app1 -f");
        System.out.println("  run application called app1, join fabric using port 9030");
        System.out.println();
        System.out.println("runapp C:\\foo\\bar\\app1");
        System.out.println("  run application rooted at specified path");
        System.out.println();
        System.out.println("runapp -a");
        System.out.println("  run all applications in application home");
    }

    private static void processArgs(String[] args) throws Throwable {
        int i = 0;
        if (args.length > 1 && args[0].equals("-jaas")) {
            i += 2;
        }
        while (i < args.length) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                appPaths = (String[])ArrayUtil.addElement(appPaths, arg);
            } else {
                if (arg.length() == 1) {
                    throw new IllegalArgumentException("a plain - is not a valid argument");
                }
                switch (arg.charAt(1)) {
                    case 'a': {
                        runAllApps = true;
                        break;
                    }
                    case 'D': {
                        ToolUtil.setProperty(arg);
                        break;
                    }
                    case 'f': {
                        fabric = true;
                        if (i >= args.length - 1 || args[i + 1].startsWith("-")) break;
                        discoveryPort = Integer.parseInt(args[++i]);
                        break;
                    }
                    case 'h': {
                        RunApp.printUsage();
                        System.exit(-1);
                    }
                    case 'p': {
                        appURL = args[++i];
                        break;
                    }
                    case 'u': {
                        appURL = args[++i];
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("illegal argument " + arg.charAt(1));
                    }
                }
            }
            ++i;
        }
    }

    private static void runapp() throws Throwable {
        if (runAllApps) {
            RunApp.startAllApplications(WebApplication.getAppHome());
        } else {
            int i = 0;
            while (i < appPaths.length) {
                RunApp.startApplication(appPaths[i]);
                ++i;
            }
        }
    }

    private static void startAllApplications(String appHome) throws Throwable {
        File[] appDirs = Utils.getAppDirs(appHome);
        int i = 0;
        while (i < appDirs.length) {
            RunApp.startApplication(appDirs[i].getCanonicalPath());
            ++i;
        }
    }

    private static void startApplication(String appPath) throws Throwable {
        if (fabric) {
            RunApp.processFabricArguments();
        }
        File appDir = Utils.getAppDir(appPath);
        WebAppMonitor appMonitor = new WebAppMonitor(appDir, appURL);
        appMonitor.start();
    }

    private static void processFabricArguments() throws Throwable {
        if (discoveryPort != -1) {
            System.setProperty("fabric.port", Integer.toString(discoveryPort));
        }
        Fabric.join();
    }

    static {
        discoveryPort = -1;
    }
}

