/*
 * Decompiled with CFR 0.152.
 */
package electric.application.tools;

import electric.application.web.WebApplication;
import electric.glue.IGLUELoggingConstants;
import electric.util.file.FileUtil;
import electric.util.log.Log;
import electric.util.path.Paths;
import electric.util.tool.ToolUtil;
import java.io.File;
import java.io.IOException;

public class NewApp
implements IGLUELoggingConstants {
    private static String appName;
    private static boolean verbose;

    public static void main(String[] args) {
        if (args.length == 0) {
            NewApp.printUsage();
            return;
        }
        try {
            NewApp.processArgs(args);
            NewApp.newapp();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            NewApp.printUsage();
            System.exit(-1);
        }
    }

    private static void printUsage() {
        System.out.println("usage: newapp [-Dname=value]* [-h] appname [-v]");
        System.out.println();
        System.out.println("where:");
        System.out.println("  -Dname=value = set java system property");
        System.out.println("  -h           = print help and exit");
        System.out.println("  appname      = name of application to create");
        System.out.println("  -v           = verbose (print out filenames as they are copied)");
        System.out.println();
        System.out.println("an application name can be specified as a relative or absolute path.");
        System.out.println("by default, relative paths are resolved from the current directory.");
        System.out.println("if you prefer that applications share a common home,");
        System.out.println("set the environment variable GLUE_APPHOME or the Java");
        System.out.println("system property glue.apphome to the application home directory.");
        System.out.println("relative paths are then resolved relative to the application home.");
        System.out.println();
        System.out.println("examples:");
        System.out.println();
        System.out.println("newapp app1");
        System.out.println("  create new application structure for app1");
    }

    private static void processArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                if (appName != null) {
                    throw new IllegalArgumentException("cannot set more than one application name " + arg);
                }
                appName = arg;
            } else {
                if (arg.length() == 1) {
                    throw new IllegalArgumentException("a plain - is not a valid argument");
                }
                switch (arg.charAt(1)) {
                    case 'D': {
                        ToolUtil.setProperty(arg);
                        break;
                    }
                    case 'h': {
                        NewApp.printUsage();
                        System.exit(-1);
                    }
                    case 'v': {
                        verbose = true;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("illegal argument " + arg.charAt(1));
                    }
                }
            }
            ++i;
        }
        if (appName == null) {
            throw new IllegalArgumentException("missing application name");
        }
    }

    private static void newapp() throws IOException {
        Log.startLogging("DEPLOYMENT");
        NewApp.install(appName, verbose);
    }

    public static void install(String appName, boolean verbose) throws IOException {
        String appHome;
        if (verbose) {
            Log.startLogging("FILE");
        }
        if ((appHome = WebApplication.getAppHome()) == null) {
            appHome = ".";
        }
        File appPathDir = new File(appHome, appName);
        appName = appPathDir.getName();
        if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
            Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)("creating application directory at " + appPathDir.getCanonicalPath()));
        }
        File sourceDir = new File(Paths.getGlueHome(), "app-template");
        if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
            Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)("copying application files from " + sourceDir.getCanonicalPath()));
        }
        FileUtil.copyFiles(sourceDir, appPathDir);
        if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
            Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)"application has been successfully created");
        }
    }
}

